/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.crud;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.tarantool.client.crud.ConditionOperator;
import java.util.Objects;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
public class Condition {
    private final String operator;
    private final String fieldIdentifier;
    private final Object value;

    public Condition(String operator, String fieldIdentifier, Object value) throws IllegalArgumentException {
        if (operator == null) {
            throw new IllegalArgumentException("operator can't be null");
        }
        if (fieldIdentifier == null) {
            throw new IllegalArgumentException("fieldIdentifier can't be null");
        }
        this.operator = operator;
        this.fieldIdentifier = fieldIdentifier;
        this.value = value;
    }

    public Condition(ConditionOperator operator, String fieldIdentifier, Object value) throws IllegalArgumentException {
        if (operator == null) {
            throw new IllegalArgumentException("operator can't be null");
        }
        if (fieldIdentifier == null) {
            throw new IllegalArgumentException("fieldIdentifier can't be null");
        }
        this.operator = operator.toString();
        this.fieldIdentifier = fieldIdentifier;
        this.value = value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Condition create(String operator, String fieldIdentifier, Object value) throws IllegalArgumentException {
        return new Condition(operator, fieldIdentifier, value);
    }

    public static Condition create(ConditionOperator operator, String fieldIdentifier, Object value) throws IllegalArgumentException {
        return new Condition(operator, fieldIdentifier, value);
    }

    public String getOperator() {
        return this.operator;
    }

    public String getFieldIdentifier() {
        return this.fieldIdentifier;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return this.operator.equals(condition.operator) && this.fieldIdentifier.equals(condition.fieldIdentifier) && Objects.equals(this.value, condition.value);
    }

    public int hashCode() {
        return Objects.hash(this.operator, this.fieldIdentifier, this.value);
    }

    public static class Builder {
        private String operator;
        private String fieldIdentifier;
        private Object value;

        public Builder withOperator(String operator) throws IllegalArgumentException {
            if (operator == null) {
                throw new IllegalArgumentException("operator can't be null");
            }
            this.operator = operator;
            return this;
        }

        public Builder withOperator(ConditionOperator operator) throws IllegalArgumentException {
            if (operator == null) {
                throw new IllegalArgumentException("operator can't be null");
            }
            this.operator = operator.toString();
            return this;
        }

        public Builder withFieldIdentifier(String fieldIdentifier) throws IllegalArgumentException {
            if (fieldIdentifier == null) {
                throw new IllegalArgumentException("fieldIdentifier can't be null");
            }
            this.fieldIdentifier = fieldIdentifier;
            return this;
        }

        public Builder withValue(Object value) {
            this.value = value;
            return this;
        }

        public Condition build() throws IllegalArgumentException {
            return new Condition(this.operator, this.fieldIdentifier, this.value);
        }
    }
}

