/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.box.options;

import io.tarantool.client.box.options.OptionsWithIndex;

public class DeleteOptions
implements OptionsWithIndex {
    public static final long DEFAULT_TIMEOUT = 5000L;
    public static final int PRIMARY = 0;
    private final long timeout;
    private final Long streamId;
    private final int indexId;
    private final String indexName;

    private DeleteOptions(long timeout, Long streamId, int indexId, String indexName) {
        this.timeout = timeout;
        this.streamId = streamId;
        this.indexId = indexId;
        this.indexName = indexName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Long getStreamId() {
        return this.streamId;
    }

    @Override
    public int getIndexId() {
        return this.indexId;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    public static class Builder {
        private long timeout = 5000L;
        private Long streamId;
        private int indexId = 0;
        private String indexName;

        public Builder withTimeout(long timeout) {
            if (timeout <= 0L) {
                throw new IllegalArgumentException("timeout should be greater than 0");
            }
            this.timeout = timeout;
            return this;
        }

        public Builder withStreamId(long streamId) {
            if (streamId < 0L) {
                throw new IllegalArgumentException("streamId should be greater or equal 0");
            }
            this.streamId = streamId;
            return this;
        }

        public Builder withIndex(int indexId) {
            if (indexId < 0) {
                throw new IllegalArgumentException("index should be greater or equal 0");
            }
            this.indexId = indexId;
            return this;
        }

        public Builder withIndex(String indexName) {
            if (indexName == null) {
                throw new IllegalArgumentException("index can't be null");
            }
            this.indexName = indexName;
            return this;
        }

        public DeleteOptions build() {
            return new DeleteOptions(this.timeout, this.streamId, this.indexId, this.indexName);
        }
    }
}

