/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.io.IOException;
import java.util.HashMap;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.ImmutableStringValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class IProtoWatch
extends IProtoBaseRequest {
    protected final String eventKey;

    public IProtoWatch(String eventKey) {
        this.eventKey = eventKey;
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException {
        this.preparePacker(packer);
        packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_ONE_ITEM);
        packer.addPayload(IProtoConstant.RAW_IPROTO_EVENT_KEY);
        packer.packString(this.eventKey);
        return this.getPacketFromBase(packer);
    }

    @Override
    public MapValue getBody() {
        HashMap<Value, ImmutableStringValue> map = new HashMap<Value, ImmutableStringValue>();
        map.put(IProtoConstant.MP_IPROTO_EVENT_KEY, ValueFactory.newString((String)this.eventKey));
        return ValueFactory.newMap(map);
    }

    @Override
    public boolean hasSyncId() {
        return false;
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoConstant.RAW_IPROTO_TYPE_WATCH;
    }

    @Override
    public int getRequestType() {
        return 74;
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoWatch(key = ").append(this.eventKey).append(")");
        }
        return this.stringBuilder.toString();
    }
}

