/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.util.Timer;
import io.tarantool.core.IProtoClient;
import io.tarantool.core.IProtoFeature;
import io.tarantool.core.Watcher;
import io.tarantool.core.WatcherOptions;
import io.tarantool.core.connection.Connection;
import io.tarantool.core.connection.ConnectionCloseEvent;
import io.tarantool.core.connection.ConnectionFactory;
import io.tarantool.core.connection.Greeting;
import io.tarantool.core.exceptions.ClientException;
import io.tarantool.core.exceptions.ShutdownException;
import io.tarantool.core.protocol.BoxIterator;
import io.tarantool.core.protocol.IProtoRequest;
import io.tarantool.core.protocol.IProtoRequestOpts;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.core.protocol.TransactionIsolationLevel;
import io.tarantool.core.protocol.fsm.IProtoStateMachine;
import io.tarantool.core.protocol.fsm.RequestStateMachine;
import io.tarantool.core.protocol.fsm.WatcherStateMachine;
import io.tarantool.core.protocol.requests.IProtoAuth;
import io.tarantool.core.protocol.requests.IProtoBegin;
import io.tarantool.core.protocol.requests.IProtoCall;
import io.tarantool.core.protocol.requests.IProtoCommit;
import io.tarantool.core.protocol.requests.IProtoDelete;
import io.tarantool.core.protocol.requests.IProtoEval;
import io.tarantool.core.protocol.requests.IProtoExecute;
import io.tarantool.core.protocol.requests.IProtoId;
import io.tarantool.core.protocol.requests.IProtoInsert;
import io.tarantool.core.protocol.requests.IProtoPing;
import io.tarantool.core.protocol.requests.IProtoPrepare;
import io.tarantool.core.protocol.requests.IProtoReplace;
import io.tarantool.core.protocol.requests.IProtoRollback;
import io.tarantool.core.protocol.requests.IProtoSelect;
import io.tarantool.core.protocol.requests.IProtoUnwatch;
import io.tarantool.core.protocol.requests.IProtoUpdate;
import io.tarantool.core.protocol.requests.IProtoUpsert;
import io.tarantool.core.protocol.requests.IProtoWatchOnce;
import io.tarantool.core.protocol.requests.SelectAfterMode;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableBooleanValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IProtoClientImpl
implements IProtoClient {
    public static final IProtoAuth.AuthType DEFAULT_AUTH_TYPE = IProtoAuth.AuthType.CHAP_SHA1;
    public static final IProtoRequestOpts DEFAULT_REQUEST_OPTS = IProtoRequestOpts.empty().withRequestTimeout(5000L);
    public static final WatcherOptions DEFAULT_WATCHER_OPTS = WatcherOptions.builder().build();
    private static final Set<IProtoFeature> FEATURES_SET_ENUM = EnumSet.allOf(IProtoFeature.class);
    private static final List<Integer> FEATURES_LIST_INT = Arrays.stream(IProtoFeature.values()).map(Enum::ordinal).collect(Collectors.toList());
    private static final int DML_TUPLE_EXTENSION_INT = IProtoFeature.DML_TUPLE_EXTENSION.ordinal();
    private static final int CALL_RET_TUPLE_EXTENSION_INT = IProtoFeature.CALL_RET_TUPLE_EXTENSION.ordinal();
    private static final String CALL_CONNECT_BEFORE_GETTING_SERVER_DETAILS = "Call connect before getting server details";
    private static final String SHUTDOWN_EVENT_KEY = "box.shutdown";
    private static final Logger log = LoggerFactory.getLogger(IProtoClientImpl.class);
    private final AtomicLong streamIdSequence;
    private final AtomicLong syncIdSequence;
    private final Connection connection;
    private final List<String> toUnwatch;
    private final Map<Long, IProtoStateMachine> fsmRegistry;
    private final Map<String, Watcher> watchers;
    private final Timer timerService;
    private final WatcherOptions watcherOpts;
    private CompletableFuture<Integer> serverProtocolVersion;
    private CompletableFuture<EnumSet<IProtoFeature>> serverFeatures;
    private Set<IProtoFeature> clientFeaturesEnum;
    private List<Integer> clientFeaturesList;
    private LongTaskTimer requestTimer;
    private Counter requestCounter;
    private Counter responseSuccessCounter;
    private Counter responseErrorCounter;
    private Counter ignoredResponsesCounter;
    private Consumer<IProtoResponse> ignoredPacketsHandler;

    public IProtoClientImpl(ConnectionFactory factory, Timer timerService) {
        this(factory, timerService, DEFAULT_WATCHER_OPTS, null, null, false);
    }

    public IProtoClientImpl(ConnectionFactory factory, Timer timerService, WatcherOptions watcherOpts, MeterRegistry metricsRegistry, FlushConsolidationHandler flushConsolidationHandler, boolean useTupleExtension) {
        if (metricsRegistry != null) {
            this.requestTimer = metricsRegistry.get("request.timer").longTaskTimer();
            this.requestCounter = metricsRegistry.get("request.counter").counter();
            this.responseSuccessCounter = metricsRegistry.get("response.success").counter();
            this.responseErrorCounter = metricsRegistry.get("response.errors").counter();
            this.ignoredResponsesCounter = metricsRegistry.get("response.ignored").counter();
        }
        this.connection = factory.create(flushConsolidationHandler).listen(this::handleMessage).onClose(ConnectionCloseEvent.CLOSE_BY_REMOTE, this::handleClose).onClose(ConnectionCloseEvent.CLOSE_BY_CLIENT, this::handleClose);
        this.fsmRegistry = new ConcurrentHashMap<Long, IProtoStateMachine>();
        this.watchers = new ConcurrentHashMap<String, Watcher>();
        this.syncIdSequence = new AtomicLong(0L);
        this.streamIdSequence = new AtomicLong(0L);
        this.timerService = timerService;
        this.toUnwatch = new ArrayList<String>();
        this.watcherOpts = watcherOpts == null ? DEFAULT_WATCHER_OPTS : watcherOpts;
        this.ignoredPacketsHandler = packet -> {};
        this.clientFeaturesEnum = FEATURES_SET_ENUM;
        this.clientFeaturesList = FEATURES_LIST_INT;
        if (!useTupleExtension) {
            this.clientFeaturesEnum = FEATURES_SET_ENUM.stream().filter(feature -> !feature.equals((Object)IProtoFeature.DML_TUPLE_EXTENSION) && !feature.equals((Object)IProtoFeature.CALL_RET_TUPLE_EXTENSION)).collect(Collectors.toSet());
            this.clientFeaturesList = FEATURES_LIST_INT.stream().filter(feature -> !feature.equals(DML_TUPLE_EXTENSION_INT) && !feature.equals(CALL_RET_TUPLE_EXTENSION_INT)).collect(Collectors.toList());
        }
        this.clientFeaturesEnum = Collections.unmodifiableSet(this.clientFeaturesEnum);
        this.serverProtocolVersion = new CompletableFuture();
        this.serverFeatures = new CompletableFuture();
        this.serverProtocolVersion.completeExceptionally(new ClientException(CALL_CONNECT_BEFORE_GETTING_SERVER_DETAILS));
        this.serverFeatures.completeExceptionally(new ClientException(CALL_CONNECT_BEFORE_GETTING_SERVER_DETAILS));
    }

    @Override
    public CompletableFuture<Void> connect(InetSocketAddress address, long timeoutMs) {
        return this.connect(address, timeoutMs, true);
    }

    @Override
    public CompletableFuture<Void> connect(InetSocketAddress address, long timeoutMs, boolean gracefulShutdown) {
        if (gracefulShutdown) {
            this.watch(SHUTDOWN_EVENT_KEY, this::shutdownEventCallback);
        }
        this.serverProtocolVersion = new CompletableFuture();
        this.serverFeatures = new CompletableFuture();
        return this.connection.connect(address, timeoutMs).thenRun(() -> {
            this.updateWatchers();
            this.updateServerInfo();
        });
    }

    @Override
    public CompletableFuture<IProtoResponse> authorize(String user, String password) {
        return this.authorize(user, password, DEFAULT_REQUEST_OPTS, DEFAULT_AUTH_TYPE);
    }

    @Override
    public CompletableFuture<IProtoResponse> authorize(String user, String password, IProtoRequestOpts opts) {
        return this.authorize(user, password, opts, DEFAULT_AUTH_TYPE);
    }

    @Override
    public CompletableFuture<IProtoResponse> authorize(String user, String password, IProtoAuth.AuthType authType) {
        return this.authorize(user, password, DEFAULT_REQUEST_OPTS, authType);
    }

    @Override
    public CompletableFuture<IProtoResponse> authorize(String user, String password, IProtoRequestOpts opts, IProtoAuth.AuthType authType) {
        Optional<Greeting> greeting = this.connection.getGreeting();
        if (!greeting.isPresent()) {
            CompletableFuture<IProtoResponse> promise = new CompletableFuture<IProtoResponse>();
            promise.completeExceptionally(new ClientException("No greeting, connect firstly!"));
            return promise;
        }
        return this.runRequest(new IProtoAuth(user, password, greeting.get().getSalt(), authType), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> select(int spaceId, int indexId, ArrayValue key, int limit, int offset, BoxIterator iterator) {
        return this.select((Integer)spaceId, null, (Integer)indexId, null, key, limit, offset, iterator, false, null, null, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> select(int spaceId, int indexId, byte[] key, int limit, int offset, BoxIterator iterator) {
        return this.select((Integer)spaceId, null, (Integer)indexId, null, key, limit, offset, iterator, false, null, null, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> select(Integer spaceId, String spaceName, Integer indexId, String indexName, ArrayValue key, int limit, int offset, BoxIterator iterator, boolean fetchPosition, byte[] after, SelectAfterMode afterMode, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoSelect(spaceId, spaceName, indexId, indexName, limit, offset, iterator.getCode(), key, opts.getStreamId(), fetchPosition, after, afterMode), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> select(Integer spaceId, String spaceName, Integer indexId, String indexName, byte[] key, int limit, int offset, BoxIterator iterator, boolean fetchPosition, byte[] after, SelectAfterMode afterMode, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoSelect(spaceId, spaceName, indexId, indexName, limit, offset, iterator.getCode(), key, opts.getStreamId(), fetchPosition, after, afterMode), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> insert(int spaceId, ArrayValue tuple) {
        return this.insert((Integer)spaceId, null, tuple, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> insert(int spaceId, byte[] tuple) {
        return this.insert((Integer)spaceId, null, tuple, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> insert(Integer spaceId, String spaceName, ArrayValue tuple, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoInsert(spaceId, spaceName, tuple, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> insert(Integer spaceId, String spaceName, byte[] tuple, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoInsert(spaceId, spaceName, tuple, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> replace(int spaceId, ArrayValue tuple) {
        return this.replace((Integer)spaceId, null, tuple, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> replace(int spaceId, byte[] tuple) {
        return this.replace((Integer)spaceId, null, tuple, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> replace(Integer spaceId, String spaceName, ArrayValue tuple, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoReplace(spaceId, spaceName, tuple, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> replace(Integer spaceId, String spaceName, byte[] tuple, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoReplace(spaceId, spaceName, tuple, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> delete(int spaceId, int indexId, ArrayValue key) {
        return this.delete((Integer)spaceId, null, (Integer)indexId, null, key, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> delete(int spaceId, int indexId, byte[] key) {
        return this.delete((Integer)spaceId, null, (Integer)indexId, null, key, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> delete(Integer spaceId, String spaceName, Integer indexId, String indexName, ArrayValue key, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoDelete(spaceId, spaceName, indexId, indexName, (Value)key, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> delete(Integer spaceId, String spaceName, Integer indexId, String indexName, byte[] key, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoDelete(spaceId, spaceName, indexId, indexName, key, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> update(int spaceId, int indexId, ArrayValue key, ArrayValue operations) {
        return this.update((Integer)spaceId, null, (Integer)indexId, null, key, operations, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> update(int spaceId, int indexId, byte[] key, byte[] operations) {
        return this.update((Integer)spaceId, null, (Integer)indexId, null, key, operations, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> update(Integer spaceId, String spaceName, Integer indexId, String indexName, ArrayValue key, ArrayValue operations, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoUpdate(spaceId, spaceName, indexId, indexName, key, operations, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> update(Integer spaceId, String spaceName, Integer indexId, String indexName, byte[] key, byte[] operations, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoUpdate(spaceId, spaceName, indexId, indexName, key, operations, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> upsert(int spaceId, int indexBase, ArrayValue tuple, ArrayValue operations) {
        return this.upsert((Integer)spaceId, null, (Integer)indexBase, tuple, operations, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> upsert(int spaceId, int indexBase, byte[] tuple, byte[] operations) {
        return this.upsert((Integer)spaceId, null, (Integer)indexBase, tuple, operations, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> upsert(Integer spaceId, String spaceName, Integer indexBaseId, ArrayValue tuple, ArrayValue operations, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoUpsert(spaceId, spaceName, (int)indexBaseId, tuple, operations, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> upsert(Integer spaceId, String spaceName, Integer indexBaseId, byte[] tuple, byte[] operations, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoUpsert(spaceId, spaceName, (int)indexBaseId, tuple, operations, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> call(String function, ArrayValue args) {
        return this.call(function, args, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> call(String function, byte[] args) {
        return this.call(function, args, null, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> call(String function, ArrayValue args, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoCall(function, args, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> call(String function, byte[] args, byte[] formats, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoCall(function, args, formats, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> eval(String expression, ArrayValue args) {
        return this.eval(expression, args, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> eval(String expression, byte[] args) {
        return this.eval(expression, args, null, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> eval(String expression, ArrayValue args, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoEval(expression, args, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> eval(String expression, byte[] args, byte[] formats, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoEval(expression, args, formats, opts.getStreamId()), opts);
    }

    @Override
    public long allocateStreamId() {
        return this.streamIdSequence.updateAndGet(n -> n == Long.MAX_VALUE ? 1L : n + 1L);
    }

    @Override
    public CompletableFuture<IProtoResponse> begin(Long streamId, long streamTimeout, TransactionIsolationLevel level) {
        return this.begin(streamId, streamTimeout, level, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> begin(Long streamId, long streamTimeout, TransactionIsolationLevel level, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoBegin(streamId, streamTimeout, level), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> commit(Long streamId) {
        return this.commit(streamId, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> commit(Long streamId, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoCommit(streamId), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> rollback(Long streamId) {
        return this.rollback(streamId, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> rollback(Long streamId, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoRollback(streamId), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> execute(long statementId, ArrayValue sqlBind, ArrayValue options) {
        return this.execute(statementId, sqlBind, options, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> execute(long statementId, byte[] sqlBind, byte[] options) {
        return this.execute(statementId, sqlBind, options, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> execute(long statementId, ArrayValue sqlBind, ArrayValue options, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoExecute(statementId, sqlBind, options, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> execute(long statementId, byte[] sqlBind, byte[] options, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoExecute(statementId, sqlBind, options, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> execute(String statementText, ArrayValue sqlBind, ArrayValue options) {
        return this.execute(statementText, sqlBind, options, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> execute(String statementText, byte[] sqlBind, byte[] options) {
        return this.execute(statementText, sqlBind, options, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> execute(String statementText, ArrayValue sqlBind, ArrayValue options, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoExecute(statementText, sqlBind, options, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> execute(String statementText, byte[] sqlBind, byte[] options, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoExecute(statementText, sqlBind, options, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> ping() {
        return this.runRequest(new IProtoPing(), DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> ping(IProtoRequestOpts opts) {
        return this.runRequest(new IProtoPing(), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> prepare(String statementText) {
        return this.prepare(statementText, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> prepare(String statementText, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoPrepare(statementText, opts.getStreamId()), opts);
    }

    @Override
    public CompletableFuture<IProtoResponse> id(int protocolVersion, List<Integer> features) {
        return this.id(protocolVersion, features, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> id(int protocolVersion, List<Integer> features, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoId(protocolVersion, features), opts);
    }

    @Override
    public void watch(String key, Consumer<IProtoResponse> callback) {
        this.watchers.compute(key, (k, watcher) -> {
            if (watcher == null) {
                watcher = new Watcher();
            }
            watcher.addRawCallback(callback);
            return watcher;
        });
        if (this.isConnected()) {
            this.updateWatchers();
        }
    }

    @Override
    public CompletableFuture<IProtoResponse> watchOnce(String key) {
        return this.watchOnce(key, DEFAULT_REQUEST_OPTS);
    }

    @Override
    public CompletableFuture<IProtoResponse> watchOnce(String key, IProtoRequestOpts opts) {
        return this.runRequest(new IProtoWatchOnce(key), opts);
    }

    @Override
    public void unwatch(String key) {
        this.watchers.computeIfPresent(key, (k, watcher) -> {
            this.fsmRegistry.remove(watcher.getSyncId());
            this.toUnwatch.add((String)k);
            return watcher;
        });
        if (this.isConnected()) {
            this.updateWatchers();
        }
    }

    @Override
    public void close() throws Exception {
        log.info("close connection {}", (Object)this.connection);
        this.connection.close();
    }

    @Override
    public IProtoClient onClose(ConnectionCloseEvent event, BiConsumer<IProtoClient, Throwable> callback) {
        this.connection.onClose(event, (Connection c, Throwable exc) -> callback.accept(this, (Throwable)exc));
        return this;
    }

    @Override
    public IProtoClient onIgnoredPacket(Consumer<IProtoResponse> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler for ignored packets should not be null");
        }
        this.ignoredPacketsHandler = handler;
        return this;
    }

    @Override
    public boolean isConnected() {
        return this.connection.isConnected();
    }

    @Override
    public Integer getClientProtocolVersion() {
        return 7;
    }

    @Override
    public Integer getServerProtocolVersion() {
        return this.serverProtocolVersion.join();
    }

    @Override
    public Set<IProtoFeature> getClientFeatures() {
        return this.clientFeaturesEnum;
    }

    @Override
    public Set<IProtoFeature> getServerFeatures() {
        return Collections.unmodifiableSet((Set)this.serverFeatures.join());
    }

    @Override
    public boolean isFeatureEnabled(IProtoFeature feature) {
        Set features = this.serverFeatures.join();
        return features.contains((Object)feature);
    }

    @Override
    public boolean hasTupleExtension() {
        return this.getClientFeatures().contains((Object)IProtoFeature.DML_TUPLE_EXTENSION) && this.getServerFeatures().contains((Object)IProtoFeature.DML_TUPLE_EXTENSION);
    }

    private synchronized void updateWatchers() {
        for (Map.Entry<String, Watcher> watcherEntry : this.watchers.entrySet()) {
            Watcher watcher = this.watchers.get(watcherEntry.getKey());
            WatcherStateMachine fsm = watcher.getStateContext();
            if (fsm != null) continue;
            long syncId = this.allocateSyncIds(1);
            fsm = new WatcherStateMachine(watcherEntry.getKey(), syncId, watcher, this.connection, this.watcherOpts, this.timerService);
            watcher.setStateContext(fsm);
            watcher.setSyncId(syncId);
            this.fsmRegistry.put(syncId, fsm);
            fsm.runOnce();
        }
        for (String key : new ArrayList<String>(this.toUnwatch)) {
            long syncId = this.allocateSyncIds(1);
            IProtoUnwatch request = new IProtoUnwatch(key);
            request.setSyncId(syncId);
            this.connection.send(request).whenComplete((v, exc) -> {
                if (exc != null) {
                    log.warn("could not send unwatch packet: %s", exc);
                    return;
                }
                this.toUnwatch.remove(key);
            });
        }
    }

    private long allocateSyncIds(int count) {
        return this.syncIdSequence.updateAndGet(n -> n + (long)count < 0L ? (long)count : n + (long)count);
    }

    private void handleMessage(IProtoResponse message) {
        IProtoStateMachine fsm;
        log.debug("IProtoClientImpl:handleMessage() - \"{}\"", (Object)message);
        long syncId = message.getSyncId();
        if (syncId == -1L) {
            if (message.getRequestType() == 76) {
                String key = message.getBodyStringValue(87).asString();
                if (!this.watchers.containsKey(key)) {
                    this.processIgnoredResponse(message);
                    log.error("Client doesn't watch this key {}", (Object)key);
                    return;
                }
                syncId = this.watchers.get(key).getSyncId();
            } else {
                this.processIgnoredResponse(message);
                log.error("Client cannot handle this message: {}", (Object)message);
                return;
            }
        }
        if ((fsm = this.fsmRegistry.get(syncId)) == null) {
            this.processIgnoredResponse(message);
        } else if (fsm.process(message)) {
            this.fsmRegistry.remove(syncId);
            if (fsm.hasNextAction()) {
                fsm.next().runOnce();
            }
        }
    }

    private void shutdownEventCallback(IProtoResponse response) {
        Value v = response.getBodyValue(88);
        if (!v.equals((Object)ImmutableBooleanValueImpl.TRUE)) {
            return;
        }
        try {
            this.connection.shutdownClose();
            this.failAllRequests(new ShutdownException());
        }
        catch (Exception e) {
            throw new ShutdownException("Shutdown process failed");
        }
    }

    private void handleClose(Connection conn, Throwable exc) {
        this.failAllRequests(exc);
        this.watchers.forEach((key, watcher) -> {
            this.fsmRegistry.remove(watcher.getSyncId());
            watcher.setStateContext(null);
        });
    }

    private CompletableFuture<IProtoResponse> runRequest(IProtoRequest request, IProtoRequestOpts opts) {
        LongTaskTimer.Sample currentRequest = null;
        if (this.requestTimer != null) {
            currentRequest = this.requestTimer.start();
            this.requestCounter.increment();
        }
        CompletableFuture<IProtoResponse> resultPromise = new CompletableFuture<IProtoResponse>();
        long syncId = this.allocateSyncIds(1);
        RequestStateMachine stateContext = new RequestStateMachine(this.connection, syncId, request, resultPromise, opts, this.fsmRegistry, this.timerService);
        LongTaskTimer.Sample finalCurrentRequest = currentRequest;
        CompletionStage promiseWithStoppers = resultPromise.whenComplete((resp, ex) -> {
            if (this.responseErrorCounter != null) {
                finalCurrentRequest.stop();
                if (ex != null) {
                    this.responseErrorCounter.increment();
                } else {
                    this.responseSuccessCounter.increment();
                }
            }
        });
        stateContext.runOnce();
        log.debug("Request \"{}\" created", (Object)request);
        return promiseWithStoppers;
    }

    private void failAllRequests(Throwable ex) {
        this.fsmRegistry.values().forEach(a -> a.kill(ex));
        this.fsmRegistry.clear();
    }

    private void processIgnoredResponse(IProtoResponse message) {
        this.ignoredPacketsHandler.accept(message);
        if (this.ignoredResponsesCounter != null) {
            this.ignoredResponsesCounter.increment();
        }
    }

    private void updateServerInfo() {
        this.id(7, this.clientFeaturesList).whenComplete((response, ex) -> {
            if (ex != null) {
                this.serverProtocolVersion.completeExceptionally((Throwable)ex);
                this.serverFeatures.completeExceptionally((Throwable)ex);
            }
            this.serverProtocolVersion.complete(response.getBodyIntegerValue(84).asInt());
            ArrayValue rawFeatures = response.getBodyArrayValue(85);
            EnumSet<IProtoFeature> serverFeatures = EnumSet.noneOf(IProtoFeature.class);
            for (Value rawFeature : rawFeatures) {
                int featureNumber = rawFeature.asIntegerValue().asInt();
                if (featureNumber >= FEATURES_SET_ENUM.size()) continue;
                serverFeatures.add(IProtoFeature.valueOf(featureNumber));
            }
            this.serverFeatures.complete(serverFeatures);
        });
    }
}

