/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data;

import io.tarantool.client.crud.TarantoolCrudClient;
import io.tarantool.mapping.Tuple;
import io.tarantool.spring.data.Helper;
import io.tarantool.spring.data.query.TarantoolCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ProxyTarantoolQueryEngine {
    private final TarantoolCrudClient client;

    public ProxyTarantoolQueryEngine(TarantoolCrudClient client) {
        Helper.assertNotNull(client, "tarantoolCrudClient must be not null");
        this.client = client;
    }

    public Collection<?> execute(TarantoolCriteria criteria, Comparator<Map.Entry<?, ?>> sort, long offset, int rows, String keyspace) {
        Helper.assertNotNull(criteria, "criteria must be not null");
        criteria.withFirst(rows);
        return (Collection)this.client.space(keyspace).select((List)criteria.getConditions(), criteria.getOptions()).join();
    }

    public <T> Collection<T> execute(TarantoolCriteria criteria, Comparator<Map.Entry<?, ?>> sort, long offset, int rows, String keyspace, Class<T> type) {
        Helper.assertNotNull(criteria, "criteria must be not null");
        criteria.withFirst(rows);
        return ProxyTarantoolQueryEngine.unwrapTuples((List)this.client.space(keyspace).select((List)criteria.getConditions(), criteria.getOptions(), type).join());
    }

    public static <T> List<T> unwrapTuples(List<Tuple<T>> tuples) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Tuple<T> t : tuples) {
            result.add(t.get());
        }
        return result;
    }

    public long count(TarantoolCriteria criteria, String keyspace) {
        Helper.assertNotNull(criteria, "criteria must be not null");
        return ((Integer)this.client.space(keyspace).count((List)criteria.getConditions()).join()).intValue();
    }
}

