/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data;

import io.tarantool.client.crud.Condition;
import io.tarantool.client.crud.TarantoolCrudClient;
import io.tarantool.mapping.Tuple;
import io.tarantool.spring.data.Helper;

public class ProxyTarantoolCrudKeyValueAdapter {
    public static final String POTENTIAL_PERFORMANCE_ISSUES_EXCEPTION_MESSAGE = "Not supported due to potential performance issues when working with large datasets. Please, use the method implementation with pagination.";
    private final TarantoolCrudClient client;

    public ProxyTarantoolCrudKeyValueAdapter(TarantoolCrudClient client) {
        this.client = client;
    }

    public Object put(Object id, Object item, String keyspace) {
        Helper.assertNotNull(id, "Id must not be 'null' for adding.");
        Helper.assertNotNull(item, "Item must not be 'null' for adding.");
        return this.client.space(keyspace).replace(item).join();
    }

    public boolean contains(Object id, String keyspace) {
        return this.client.space(keyspace).get(id).join() != null;
    }

    public Object get(Object id, String keyspace) {
        return this.client.space(keyspace).get(id).join();
    }

    public <T> T get(Object id, String keyspace, Class<T> type) {
        return ProxyTarantoolCrudKeyValueAdapter.unwrapTuple((Tuple)this.client.space(keyspace).get(id, type).join());
    }

    public static <T> T unwrapTuple(Tuple<T> tuple) {
        if (tuple != null) {
            return (T)tuple.get();
        }
        return null;
    }

    public Object delete(Object id, String keyspace) {
        return this.client.space(keyspace).delete(id).join();
    }

    public <T> T delete(Object id, String keyspace, Class<T> type) {
        return ProxyTarantoolCrudKeyValueAdapter.unwrapTuple((Tuple)this.client.space(keyspace).delete(id, type).join());
    }

    public Iterable<?> getAllOf(String keyspace) {
        throw new UnsupportedOperationException(POTENTIAL_PERFORMANCE_ISSUES_EXCEPTION_MESSAGE);
    }

    public void deleteAllOf(String keyspace) {
        this.client.space(keyspace).truncate().join();
    }

    public void clear() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void destroy() throws Exception {
        this.client.close();
    }

    public long count(String keyspace) {
        return ((Integer)this.client.space(keyspace).count(new Condition[0]).join()).intValue();
    }
}

