/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.mapping;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.tarantool.mapping.JacksonMappingException;
import io.tarantool.mapping.TarantoolDeserializer;
import io.tarantool.mapping.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;

public class UUIDExtensionModule {
    private static final ThreadLocal<StringBuilder> threadLocalStringBuilder;
    public static final SimpleModule INSTANCE;

    private UUIDExtensionModule() {
    }

    static {
        INSTANCE = new SimpleModule("msgpack-ext-uuid");
        threadLocalStringBuilder = ThreadLocal.withInitial(StringBuilder::new);
        INSTANCE.addSerializer(UUID.class, (JsonSerializer)new UUIDSerializer(UUID.class));
        INSTANCE.addDeserializer(UUID.class, (JsonDeserializer)new UUIDDeserializer(UUID.class));
    }

    public static class UUIDSerializer
    extends StdSerializer<UUID> {
        public UUIDSerializer(Class<UUID> t) {
            super(t);
        }

        public void serialize(UUID value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
            long mostSignificant = value.getMostSignificantBits();
            buffer.putInt((int)(mostSignificant >>> 32)).putShort((short)((mostSignificant & 0xFFFFFFFFL) >>> 16)).putShort((short)(mostSignificant & 0xFFFFL));
            long leastSignificant = value.getLeastSignificantBits();
            buffer.put((byte)(leastSignificant >>> 56)).put((byte)((leastSignificant & 0xFF000000000000L) >>> 48)).put((byte)((leastSignificant & 0xFF0000000000L) >>> 40)).put((byte)((leastSignificant & 0xFF00000000L) >>> 32)).put((byte)((leastSignificant & 0xFF000000L) >>> 24)).put((byte)((leastSignificant & 0xFF0000L) >>> 16)).put((byte)((leastSignificant & 0xFF00L) >>> 8)).put((byte)(leastSignificant & 0xFFL));
            MessagePackExtensionType extensionType = new MessagePackExtensionType(2, buffer.array());
            gen.writeObject((Object)extensionType);
        }
    }

    public static class UUIDDeserializer
    extends StdDeserializer<UUID>
    implements TarantoolDeserializer<UUID> {
        public UUIDDeserializer(Class<?> vc) {
            super(vc);
        }

        public UUID deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            MessagePackExtensionType ext = (MessagePackExtensionType)p.readValueAs(MessagePackExtensionType.class);
            if (ext.getType() != 2) {
                StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                throw new JacksonMappingException(sb.delete(0, sb.length()).append("Unexpected extension type (0x").append(Utils.byteToHex(ext.getType())).append(") for UUID object").toString());
            }
            return this.deserialize(ext);
        }

        @Override
        public UUID deserialize(MessagePackExtensionType ext) {
            ByteBuffer buffer = ByteBuffer.wrap(ext.getData());
            long mostSignificant = ((long)buffer.getInt() & 0xFFFFFFFFL) << 32 | ((long)buffer.getShort() & 0xFFFFL) << 16 | (long)buffer.getShort() & 0xFFFFL;
            long leastSignificant = ((long)buffer.get() & 0xFFL) << 56 | ((long)buffer.get() & 0xFFL) << 48 | ((long)buffer.get() & 0xFFL) << 40 | ((long)buffer.get() & 0xFFL) << 32 | ((long)buffer.get() & 0xFFL) << 24 | ((long)buffer.get() & 0xFFL) << 16 | ((long)buffer.get() & 0xFFL) << 8 | (long)buffer.get() & 0xFFL;
            return new UUID(mostSignificant, leastSignificant);
        }
    }
}

