/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.mapping;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.tarantool.mapping.JacksonMappingException;
import io.tarantool.mapping.TarantoolDeserializer;
import io.tarantool.mapping.Utils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;

public class DecimalExtensionModule {
    private static final ThreadLocal<StringBuilder> threadLocalStringBuilder;
    private static final int DECIMAL_MAX_DIGITS = 38;
    private static final byte DECIMAL_MINUS = 13;
    private static final byte DECIMAL_MINUS_ALT = 11;
    private static final byte DECIMAL_PLUS = 12;
    private static final String INVALID_DIGIT_AT_POSITION = "Invalid digit at position ";
    private static final String GREATER_DECIMAL_MAX_DIGITS_ERR = "Scales with absolute value greater than 38 are not supported";
    public static final SimpleModule INSTANCE;

    private DecimalExtensionModule() {
    }

    static {
        INSTANCE = new SimpleModule("msgpack-ext-decimal");
        threadLocalStringBuilder = ThreadLocal.withInitial(StringBuilder::new);
        INSTANCE.addSerializer(BigDecimal.class, (JsonSerializer)new BigDecimalSerializer(BigDecimal.class));
        INSTANCE.addDeserializer(BigDecimal.class, (JsonDeserializer)new BigDecimalDeserializer(BigDecimal.class));
    }

    public static class BigDecimalSerializer
    extends StdSerializer<BigDecimal> {
        public BigDecimalSerializer(Class<BigDecimal> t) {
            super(t);
        }

        public void serialize(BigDecimal value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            MessagePackExtensionType extensionType;
            int scale = value.scale();
            if (scale > 38 || scale < -38) {
                throw new IOException(DecimalExtensionModule.GREATER_DECIMAL_MAX_DIGITS_ERR);
            }
            String number = value.unscaledValue().toString();
            int signum = 12;
            int digitsNum = number.length();
            int pos = 0;
            if (number.charAt(0) == '-') {
                signum = 13;
                --digitsNum;
                ++pos;
            }
            int len = (digitsNum >> 1) + 1;
            byte[] bcd = new byte[len];
            bcd[len - 1] = signum;
            char[] digits = number.substring(pos).toCharArray();
            pos = digits.length - 1;
            for (int i = len - 1; i > 0; --i) {
                int n = i;
                bcd[n] = (byte)(bcd[n] | (byte)(Character.digit(digits[pos--], 10) << 4));
                int n2 = i - 1;
                bcd[n2] = (byte)(bcd[n2] | (byte)Character.digit(digits[pos--], 10));
            }
            if (pos == 0) {
                bcd[0] = (byte)(bcd[0] | (byte)(Character.digit(digits[pos], 10) << 4));
            }
            try (MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();){
                packer.packInt(scale);
                packer.writePayload(bcd);
                extensionType = new MessagePackExtensionType(1, packer.toByteArray());
            }
            gen.writeObject((Object)extensionType);
        }
    }

    public static class BigDecimalDeserializer
    extends StdDeserializer<BigDecimal>
    implements TarantoolDeserializer<BigDecimal> {
        public BigDecimalDeserializer(Class<?> vc) {
            super(vc);
        }

        public BigDecimal deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            MessagePackExtensionType ext = (MessagePackExtensionType)p.readValueAs(MessagePackExtensionType.class);
            if (ext.getType() != 1) {
                StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                throw new JacksonMappingException(sb.delete(0, sb.length()).append("Unexpected extension type (0x").append(Utils.byteToHex(ext.getType())).append(") for BigDecimal object").toString());
            }
            return this.deserialize(ext);
        }

        @Override
        public BigDecimal deserialize(MessagePackExtensionType ext) throws IOException {
            int i;
            int scaleSize;
            int scale;
            byte[] data = ext.getData();
            try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])data);){
                scale = unpacker.unpackInt();
                scaleSize = (int)unpacker.getTotalReadBytes();
                if (!unpacker.hasNext()) {
                    throw new IOException("Not enough bytes in the packed data");
                }
            }
            if (scale > 38 || scale < -38) {
                throw new IOException(DecimalExtensionModule.GREATER_DECIMAL_MAX_DIGITS_ERR);
            }
            int len = data.length;
            int signum = data[len - 1] & 0xF;
            if (signum == 13 || signum == 11) {
                signum = -1;
            } else {
                if (signum <= 9) {
                    throw new IOException("The sign nibble has wrong value");
                }
                signum = 1;
            }
            for (i = scaleSize; i < len && data[i] == 0; ++i) {
            }
            if (len == i && (data[len - 1] & 0xF0) == 0) {
                return BigDecimal.ZERO;
            }
            int digitsNum = len - i << 1;
            char digit = (char)((data[len - 1] & 0xF0) >>> 4);
            if (digit > '\t') {
                StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                throw new IOException(sb.delete(0, sb.length()).append(DecimalExtensionModule.INVALID_DIGIT_AT_POSITION).append(digitsNum - 1).toString());
            }
            char[] digits = new char[digitsNum];
            int pos = 2 * (len - i) - 1;
            digits[pos--] = Character.forDigit(digit, 10);
            for (int j = len - 2; j > scaleSize - 1; --j) {
                digit = (char)(data[j] & 0xF);
                if (digit > '\t') {
                    StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                    throw new IOException(sb.delete(0, sb.length()).append(DecimalExtensionModule.INVALID_DIGIT_AT_POSITION).append(pos).toString());
                }
                digits[pos--] = Character.forDigit(digit, 10);
                digit = (char)((data[j] & 0xF0) >>> 4);
                if (digit > '\t') {
                    StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                    throw new IOException(sb.delete(0, sb.length()).append(DecimalExtensionModule.INVALID_DIGIT_AT_POSITION).append(pos - 1).toString());
                }
                digits[pos--] = Character.forDigit(digit, 10);
            }
            StringBuilder sb = new StringBuilder(len - i + 1);
            if (signum < 0) {
                sb.append('-');
            }
            pos = 0;
            while (digits[pos] == '\u0000') {
                ++pos;
            }
            while (pos < digits.length) {
                sb.append(digits[pos]);
                ++pos;
            }
            return new BigDecimal(new BigInteger(sb.toString()), scale);
        }
    }
}

