/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data31.repository;

import io.tarantool.client.crud.TarantoolCrudClient;
import io.tarantool.spring.data31.repository.config.TarantoolQueryLookupStrategy;
import io.tarantool.spring.data31.repository.support.TarantoolSimpleRepository;
import java.util.Optional;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.query.SpelQueryCreator;
import org.springframework.data.keyvalue.repository.support.KeyValueRepositoryFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;

public class TarantoolRepositoryFactory
extends KeyValueRepositoryFactory {
    private static final Class<SpelQueryCreator> DEFAULT_QUERY_CREATOR = SpelQueryCreator.class;
    private final KeyValueOperations keyValueOperations;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
    private final TarantoolCrudClient client;

    public TarantoolRepositoryFactory(TarantoolCrudClient client, KeyValueOperations keyValueOperations) {
        this(client, keyValueOperations, DEFAULT_QUERY_CREATOR);
    }

    public TarantoolRepositoryFactory(TarantoolCrudClient client, KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        super(keyValueOperations, queryCreator);
        this.client = client;
        this.keyValueOperations = keyValueOperations;
        this.queryCreator = queryCreator;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new TarantoolQueryLookupStrategy(this.client, key, evaluationContextProvider, this.keyValueOperations, this.queryCreator));
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return TarantoolSimpleRepository.class;
    }
}

