/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data31.query;

import io.tarantool.client.crud.Condition;
import io.tarantool.client.crud.ConditionOperator;
import io.tarantool.spring.data.query.TarantoolCriteria;
import io.tarantool.spring.data31.query.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class TarantoolQueryCreator
extends AbstractQueryCreator<KeyValueQuery<TarantoolCriteria>, TarantoolCriteria> {
    private final Map<Part, String> cache = new ConcurrentHashMap<Part, String>();
    public static final String INVALID_DATA_ACCESS_API_USAGE_EXCEPTION_MESSAGE_TEMPLATE = "Logic error for '%s' in query. ";

    public TarantoolQueryCreator(PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
    }

    private String getFieldName(Part part) {
        PropertyPath property = part.getProperty();
        String segment = property.toDotPath();
        Class domainType = property.getOwningType().getType();
        java.lang.reflect.Field field = ReflectionUtils.findField((Class)domainType, (String)segment);
        if (field == null) {
            throw new IllegalArgumentException("No such field: " + segment + " in " + String.valueOf(domainType));
        }
        Field annotationField = field.getAnnotation(Field.class);
        if (annotationField != null) {
            String value = annotationField.value();
            if (StringUtils.hasText((String)value)) {
                return value;
            }
            String name = annotationField.name();
            if (StringUtils.hasText((String)name)) {
                return name;
            }
        }
        return segment;
    }

    @NonNull
    protected TarantoolCriteria create(Part part, @NonNull Iterator<Object> iterator) {
        TarantoolCriteria tarantoolCriteria = new TarantoolCriteria();
        Part.Type type = part.getType();
        if (this.isIgnoreCase(part)) {
            throw new InvalidDataAccessApiUsageException(String.format("Logic error for '%s' in query. IgnoreCase isn't supported yet", type));
        }
        String property = this.cache.computeIfAbsent(part, this::getFieldName);
        switch (type) {
            case SIMPLE_PROPERTY: {
                this.generateConditions(tarantoolCriteria, type, property, iterator, ConditionOperator.EQ);
                break;
            }
            case LESS_THAN: 
            case BEFORE: {
                this.generateConditions(tarantoolCriteria, type, property, iterator, ConditionOperator.LESS);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.generateConditions(tarantoolCriteria, type, property, iterator, ConditionOperator.LESS_EQ);
                break;
            }
            case GREATER_THAN: 
            case AFTER: {
                this.generateConditions(tarantoolCriteria, type, property, iterator, ConditionOperator.GREATER);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.generateConditions(tarantoolCriteria, type, property, iterator, ConditionOperator.GREATER_EQ);
                break;
            }
            case BETWEEN: {
                this.generateConditions(tarantoolCriteria, type, property, iterator, ConditionOperator.GREATER, ConditionOperator.LESS);
                break;
            }
            case TRUE: {
                tarantoolCriteria.addCondition(Condition.create((ConditionOperator)ConditionOperator.EQ, (String)property, (Object)true));
                break;
            }
            case FALSE: {
                tarantoolCriteria.addCondition(Condition.create((ConditionOperator)ConditionOperator.EQ, (String)property, (Object)false));
                break;
            }
            case IS_EMPTY: {
                tarantoolCriteria.addCondition(Condition.create((ConditionOperator)ConditionOperator.EQ, (String)property, (Object)""));
                break;
            }
            case IS_NULL: {
                tarantoolCriteria.addCondition(Condition.create((ConditionOperator)ConditionOperator.EQ, (String)property, null));
                break;
            }
            default: {
                throw new InvalidDataAccessApiUsageException(String.format("Unsupported type '%s'", type));
            }
        }
        return tarantoolCriteria;
    }

    private void generateConditions(TarantoolCriteria tarantoolCriteria, Part.Type type, String property, Iterator<Object> iterator, ConditionOperator ... operators) {
        for (int i = 0; i < type.getNumberOfArguments(); ++i) {
            if (!iterator.hasNext()) {
                throw new InvalidDataAccessApiUsageException(String.format("Logic error for '%s' in query. Transmitted not enough arguments (%d of %d)", type, i, type.getNumberOfArguments()));
            }
            tarantoolCriteria.addCondition(Condition.create((ConditionOperator)operators[i], (String)property, (Object)iterator.next()));
        }
    }

    private boolean isIgnoreCase(Part part) {
        switch (part.shouldIgnoreCase()) {
            case ALWAYS: {
                Assert.state((boolean)this.canUpperCase(part.getProperty()), (String)String.format("Unable to ignore case of %s types, the property '%s' must reference a String", part.getProperty().getType().getName(), part.getProperty().getSegment()));
                return true;
            }
            case WHEN_POSSIBLE: {
                return this.canUpperCase(part.getProperty());
            }
        }
        return false;
    }

    private boolean canUpperCase(PropertyPath path) {
        return String.class.equals((Object)path.getType());
    }

    @NonNull
    protected TarantoolCriteria and(@NonNull Part part, @NonNull TarantoolCriteria base, @NonNull Iterator<Object> iterator) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    protected TarantoolCriteria or(@NonNull TarantoolCriteria base, @NonNull TarantoolCriteria criteria) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    protected KeyValueQuery<TarantoolCriteria> complete(@Nullable TarantoolCriteria criteria, @NonNull Sort sort) {
        return new KeyValueQuery((Object)criteria);
    }
}

