/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data31.query;

import io.tarantool.client.crud.Condition;
import io.tarantool.client.crud.ConditionOperator;
import io.tarantool.spring.data.query.PaginationDirection;
import io.tarantool.spring.data.query.TarantoolCriteria;
import io.tarantool.spring.data.utils.Pair;
import io.tarantool.spring.data31.query.PaginationUtils;
import io.tarantool.spring.data31.query.TarantoolKeysetScrollPosition;
import io.tarantool.spring.data31.query.TarantoolPageable;
import io.tarantool.spring.data31.query.TarantoolSliceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.keyvalue.repository.query.KeyValuePartTreeQuery;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.StreamUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class TarantoolPartTreeQuery
extends KeyValuePartTreeQuery {
    public static final String ILLEGAL_RETURN_TYPE_FOR_DELETE = "Illegal returned type: %s. The operation 'deleteBy' accepts only 'long' and 'Collection' as the returned object type";
    public static final String QUERY_METHOD_S_NOT_SUPPORTED = "Query method '%s' not supported.";
    private final QueryMethod queryMethod;
    private final KeyValueOperations keyValueOperations;
    private final PartTree tree;
    private final boolean isCount;
    private final boolean isDelete;
    private final boolean isDistinct;
    private final boolean isExists;
    private final Class<?> targetType;
    private final Class<?> returnType;
    private boolean isRearrangeKnown;
    private boolean isRearrangeRequired;
    private int[] rearrangeIndex;
    private final List<?> EMPTY_KEY = Collections.emptyList();

    public TarantoolPartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evaluationContextProvider, KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        super(queryMethod, evaluationContextProvider, keyValueOperations, queryCreator);
        this.queryMethod = queryMethod;
        this.keyValueOperations = keyValueOperations;
        this.isRearrangeKnown = false;
        this.targetType = queryMethod.getEntityInformation().getJavaType();
        this.returnType = queryMethod.getReturnedObjectType();
        this.tree = new PartTree(this.getQueryMethod().getName(), this.targetType);
        if (queryMethod.getParameters().getNumberOfParameters() > 0) {
            this.isCount = this.tree.isCountProjection();
            this.isDelete = this.tree.isDelete();
            this.isDistinct = this.tree.isDistinct();
            this.isExists = this.tree.isExistsProjection();
        } else {
            this.isCount = false;
            this.isDelete = false;
            this.isDistinct = false;
            this.isExists = false;
        }
    }

    public Object execute(@NonNull Object[] parameters) {
        ParametersParameterAccessor accessor = this.prepareAccessor(parameters, this.tree);
        KeyValueQuery<?> query = this.prepareQuery(accessor);
        if (this.isCount) {
            if (this.isDistinct) {
                Iterable iterable = this.keyValueOperations.find(query, this.targetType);
                return StreamUtils.createStreamFromIterator(iterable.iterator()).distinct().count();
            }
            return this.keyValueOperations.count(query, this.targetType);
        }
        if (this.isDelete) {
            return this.executeDeleteQuery(query);
        }
        if (this.isExists) {
            query.setOffset(0L);
            query.setRows(1);
            Iterable result = this.keyValueOperations.find(query, this.targetType);
            return result.iterator().hasNext();
        }
        if (this.queryMethod.isPageQuery()) {
            return this.executePageQuery(query, accessor);
        }
        if (this.queryMethod.isSliceQuery()) {
            return this.executeSliceQuery(query, accessor);
        }
        if (this.queryMethod.isScrollQuery()) {
            return this.executeScrollQuery(query, accessor);
        }
        if (this.queryMethod.isCollectionQuery() || this.queryMethod.isQueryForEntity() || this.queryMethod.isStreamQuery()) {
            return this.executeFindQuery(query);
        }
        throw new UnsupportedOperationException(String.format(QUERY_METHOD_S_NOT_SUPPORTED, this.queryMethod.getName()));
    }

    private Object executeDeleteQuery(KeyValueQuery<?> query) {
        Iterable resultSet = this.keyValueOperations.find(query, this.targetType);
        Iterator iterator = resultSet.iterator();
        ArrayList<Object> result = new ArrayList<Object>();
        while (iterator.hasNext()) {
            result.add(this.keyValueOperations.delete(iterator.next()));
        }
        if (this.queryMethod.isCollectionQuery()) {
            return result;
        }
        if (Long.TYPE.equals(this.returnType) || Long.class.equals(this.returnType)) {
            return result.size();
        }
        throw new UnsupportedOperationException(String.format(ILLEGAL_RETURN_TYPE_FOR_DELETE, this.returnType));
    }

    private Object executeFindQuery(KeyValueQuery<?> query) {
        Iterable resultSet = this.keyValueOperations.find(query, this.targetType);
        if (!(this.queryMethod.isCollectionQuery() || this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery() || this.queryMethod.isStreamQuery())) {
            return resultSet.iterator().hasNext() ? resultSet.iterator().next() : null;
        }
        Stream stream = StreamUtils.createStreamFromIterator(resultSet.iterator());
        if (this.isDistinct) {
            stream = stream.distinct();
        }
        if (this.queryMethod.isStreamQuery()) {
            return stream;
        }
        if (this.isDistinct) {
            return stream.collect(Collectors.toList());
        }
        return resultSet;
    }

    private Object executeScrollQuery(KeyValueQuery<?> query, ParametersParameterAccessor accessor) {
        ScrollPosition scrollPosition = accessor.getScrollPosition();
        Assert.notNull((Object)scrollPosition, (String)("The ScrollPosition parameter must be specified. Method: " + this.queryMethod.getName()));
        if (!(scrollPosition instanceof TarantoolKeysetScrollPosition)) {
            throw new IllegalArgumentException("ScrollPosition must be an instance of TarantoolKeysetScrollPosition. Method: " + this.queryMethod.getName());
        }
        TarantoolKeysetScrollPosition keysetScrollPosition = (TarantoolKeysetScrollPosition)scrollPosition;
        int pageSize = query.getRows();
        List<?> content = this.doScrollQuery(query, keysetScrollPosition, pageSize + 1);
        boolean hasNext = content.size() > pageSize;
        List<?> finalResult = this.getPaginationSubResult(content, pageSize, PaginationDirection.FORWARD, hasNext);
        return Window.from(finalResult, value -> new TarantoolKeysetScrollPosition(keysetScrollPosition.getIndexKey(), keysetScrollPosition.getDirection(), finalResult.get(value)), (boolean)hasNext);
    }

    private List<?> doScrollQuery(KeyValueQuery<?> query, TarantoolKeysetScrollPosition scrollPosition, int pageSize) {
        TarantoolCriteria criteria = this.castToTarantoolCriteria(query.getCriteria());
        PaginationDirection paginationDirection = scrollPosition.getDirection();
        Object cursor = scrollPosition.getCursor();
        Pair<String, ?> indexKey = scrollPosition.getIndexKey();
        Object second = this.EMPTY_KEY;
        if (cursor == null) {
            second = indexKey.getSecond();
        }
        switch (paginationDirection) {
            case FORWARD: {
                criteria.addCondition(0, Condition.create((ConditionOperator)ConditionOperator.GREATER_EQ, (String)((String)indexKey.getFirst()), (Object)second));
                break;
            }
            case BACKWARD: {
                criteria.addCondition(0, Condition.create((ConditionOperator)ConditionOperator.LESS_EQ, (String)((String)indexKey.getFirst()), (Object)second));
            }
        }
        criteria.withAfter(cursor);
        query.setRows(pageSize);
        return IterableConverter.toList((Iterable)this.keyValueOperations.find(query, this.targetType));
    }

    private Object executePageQuery(KeyValueQuery<?> query, ParametersParameterAccessor accessor) {
        Pageable pageParams = accessor.getPageable();
        return PaginationUtils.doPageQuery(pageParams, query, this.keyValueOperations, this.targetType);
    }

    private Object executeSliceQuery(KeyValueQuery<?> query, ParametersParameterAccessor accessor) {
        int pageSize;
        Pageable sliceParams = accessor.getPageable();
        if (sliceParams.isUnpaged()) {
            return new TarantoolSliceImpl(Collections.emptyList());
        }
        TarantoolPageable<?> resultSliceParams = this.castToTarantoolPageable(sliceParams);
        List<?> content = PaginationUtils.doPaginationQuery(query, resultSliceParams, (pageSize = resultSliceParams.getPageSize()) + 1, this.keyValueOperations, this.targetType);
        if (content.isEmpty()) {
            return new TarantoolSliceImpl();
        }
        boolean hasNext = content.size() > resultSliceParams.getPageSize();
        PaginationDirection paginationDirection = resultSliceParams.getPaginationDirection();
        List<?> result = this.getPaginationSubResult(content, pageSize, paginationDirection, hasNext);
        return new TarantoolSliceImpl(result, resultSliceParams, hasNext);
    }

    private TarantoolPageable<?> castToTarantoolPageable(Pageable sliceParams) {
        Assert.isInstanceOf(TarantoolPageable.class, (Object)sliceParams, (String)"Pageable must be TarantoolPageable");
        return (TarantoolPageable)sliceParams;
    }

    private TarantoolCriteria castToTarantoolCriteria(Object criteria) {
        if (criteria == null) {
            return new TarantoolCriteria();
        }
        if (!(criteria instanceof TarantoolCriteria)) {
            throw new IllegalArgumentException("criteria must be instance of TarantoolCriteria");
        }
        return (TarantoolCriteria)criteria;
    }

    private List<?> getPaginationSubResult(List<?> content, int pageSize, PaginationDirection direction, boolean hasNext) {
        if (hasNext) {
            switch (direction) {
                case FORWARD: {
                    return content.subList(0, pageSize);
                }
                case BACKWARD: {
                    return content.subList(1, content.size());
                }
            }
        }
        return content;
    }

    @NonNull
    protected KeyValueQuery<?> prepareQuery(ParametersParameterAccessor accessor) {
        KeyValueQuery query = this.createQuery((ParameterAccessor)accessor);
        if (!this.tree.isLimiting()) {
            query.setRows(100);
        }
        if (accessor.getSort() != Sort.unsorted()) {
            query.setSort(accessor.getSort());
        }
        return query;
    }

    private ParametersParameterAccessor prepareAccessor(Object[] originalParameters, PartTree partTree) {
        if (!this.isRearrangeKnown) {
            this.prepareRearrange(partTree, this.queryMethod.getParameters().getBindableParameters());
            this.isRearrangeKnown = true;
        }
        Object[] parameters = originalParameters;
        Assert.notNull((Object)parameters, (String)"Parameters must not be null.");
        if (this.isRearrangeRequired) {
            parameters = new Object[originalParameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                int index = i < this.rearrangeIndex.length ? this.rearrangeIndex[i] : i;
                parameters[i] = originalParameters[index];
            }
        }
        return new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
    }

    private void prepareRearrange(PartTree partTree, Parameters<?, ?> bindableParameters) {
        this.isRearrangeRequired = false;
        if (partTree == null || bindableParameters == null) {
            return;
        }
        ArrayList<String> queryParams = new ArrayList<String>();
        ArrayList methodParams = new ArrayList();
        for (Part part : partTree.getParts()) {
            queryParams.add(part.getProperty().getSegment());
        }
        for (Parameter parameter : bindableParameters) {
            parameter.getName().ifPresent(methodParams::add);
        }
        this.rearrangeIndex = new int[queryParams.size()];
        String[] paramsExpected = queryParams.toArray(new String[0]);
        String[] paramsProvided = methodParams.toArray(new String[0]);
        for (int i = 0; i < this.rearrangeIndex.length; ++i) {
            this.rearrangeIndex[i] = i;
            for (int j = 0; j < paramsProvided.length; ++j) {
                if (paramsProvided[j] == null || !paramsProvided[j].equals(paramsExpected[i])) continue;
                this.rearrangeIndex[i] = j;
                this.isRearrangeRequired = true;
            }
        }
    }
}

