/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data31.query;

import io.tarantool.spring.data31.query.TarantoolChunk;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;

class TarantoolPageImpl<T>
extends TarantoolChunk<T>
implements Page<T> {
    private static final long serialVersionUID = 867755909294344406L;
    private final long total;

    public TarantoolPageImpl() {
        this(Collections.emptyList(), Pageable.unpaged(), 0L);
    }

    public TarantoolPageImpl(List<T> content) {
        this(content, Pageable.unpaged(), content == null ? 0L : (long)content.size());
    }

    public TarantoolPageImpl(List<T> content, Pageable pageable, long total) {
        super(content, pageable);
        this.total = pageable.toOptional().filter(it -> !content.isEmpty()).filter(it -> it.getOffset() + (long)it.getPageSize() > total).map((? super T it) -> it.getOffset() + (long)content.size()).orElse(total);
    }

    public int getTotalPages() {
        return this.getSize() == 0 ? 1 : (int)Math.ceil((double)this.total / (double)this.getSize());
    }

    public long getTotalElements() {
        return this.total;
    }

    public boolean hasNext() {
        return this.getNumber() + 1 < this.getTotalPages() && this.hasContent();
    }

    @Override
    public boolean isLast() {
        return !this.hasNext();
    }

    @NonNull
    public <U> Page<U> map(@NonNull Function<? super T, ? extends U> converter) {
        return new PageImpl(this.getConvertedContent(converter), this.getPageable(), this.total);
    }

    public String toString() {
        List content = this.getContent();
        boolean canGetContentType = !content.isEmpty() && content.get(0) != null;
        String contentType = canGetContentType ? content.get(0).getClass().getName() : "UNKNOWN";
        return String.format("Page %s of %d containing %s instances", this.getNumber() + 1, this.getTotalPages(), contentType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TarantoolPageImpl)) {
            return false;
        }
        TarantoolPageImpl that = (TarantoolPageImpl)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.total == that.total;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.total);
    }
}

