/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data31.query;

import io.tarantool.spring.data.query.PaginationDirection;
import io.tarantool.spring.data.utils.Pair;
import io.tarantool.spring.data31.query.TarantoolScrollPosition;
import java.util.List;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class TarantoolKeysetScrollPosition
implements TarantoolScrollPosition {
    private final Pair<String, ?> indexKey;
    private final PaginationDirection direction;
    private final Object cursor;

    TarantoolKeysetScrollPosition(Pair<String, ?> indexKey, PaginationDirection direction, @Nullable Object cursor) {
        Assert.notNull((Object)direction, (String)"PaginationDirection must not be null");
        Assert.notNull(indexKey, (String)"indexKey must not be null");
        this.indexKey = indexKey;
        this.direction = direction;
        this.cursor = cursor;
    }

    static TarantoolScrollPosition forward(Pair<String, ?> indexKey) {
        return new TarantoolKeysetScrollPosition(indexKey, PaginationDirection.FORWARD, null);
    }

    static TarantoolScrollPosition backward(Pair<String, ?> indexKey) {
        return new TarantoolKeysetScrollPosition(indexKey, PaginationDirection.BACKWARD, null);
    }

    public boolean isInitial() {
        Object object = this.indexKey.getSecond();
        if (object instanceof List) {
            List startingList = (List)object;
            return startingList.isEmpty() && this.cursor == null;
        }
        return false;
    }

    @Override
    public TarantoolScrollPosition reverse() {
        Pair newIndexKey = Pair.of((Object)((String)this.indexKey.getFirst()), (Object)this.indexKey.getSecond());
        return new TarantoolKeysetScrollPosition(newIndexKey, this.direction.reverse(), this.cursor);
    }

    @Override
    public boolean isScrollsBackward() {
        return this.direction.equals((Object)PaginationDirection.BACKWARD);
    }

    Object getCursor() {
        return this.cursor;
    }

    PaginationDirection getDirection() {
        return this.direction;
    }

    Pair<String, ?> getIndexKey() {
        return this.indexKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TarantoolKeysetScrollPosition)) {
            return false;
        }
        TarantoolKeysetScrollPosition that = (TarantoolKeysetScrollPosition)o;
        return this.indexKey.equals(that.indexKey) && this.direction == that.direction && Objects.equals(this.cursor, that.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.indexKey, this.direction, this.cursor);
    }

    public String toString() {
        return String.format("TarantoolKeysetScrollPosition [%s, %s, %s]", this.direction, this.indexKey, this.cursor);
    }
}

