/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data31.query;

import io.tarantool.spring.data31.query.TarantoolPageable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

abstract class TarantoolChunk<T>
implements Slice<T>,
Serializable {
    private static final long serialVersionUID = 867755909294344406L;
    private final List<T> content = new ArrayList<T>();
    private final Pageable pageable;

    public TarantoolChunk(List<T> content, Pageable pageable) {
        Assert.notNull(content, (String)"Content must not be null");
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        if (pageable.isPaged() && !(pageable instanceof TarantoolPageable)) {
            throw new IllegalArgumentException("Pageable must be TarantoolPageable<T> or Unpaged type");
        }
        this.content.addAll(content);
        this.pageable = pageable;
    }

    public boolean isFirst() {
        return !this.hasPrevious();
    }

    public boolean isLast() {
        return !this.hasNext();
    }

    public boolean hasPrevious() {
        return this.getNumber() > 0 && this.hasContent();
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    @NonNull
    public Pageable nextPageable() {
        if (this.hasNext() && this.pageable.isPaged()) {
            return ((TarantoolPageable)this.pageable).next(this.content.get(this.content.size() - 1));
        }
        return Pageable.unpaged();
    }

    @NonNull
    public Pageable previousPageable() {
        if (this.hasPrevious() && this.pageable.isPaged()) {
            return ((TarantoolPageable)this.pageable).previousOrFirst(this.content.get(0));
        }
        return Pageable.unpaged();
    }

    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    @NonNull
    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    @NonNull
    public Pageable getPageable() {
        return this.pageable;
    }

    @NonNull
    public Sort getSort() {
        return this.pageable.getSort();
    }

    public int getNumber() {
        if (this.pageable.isPaged()) {
            return this.pageable.getPageNumber();
        }
        return 0;
    }

    public int getSize() {
        if (this.pageable.isPaged()) {
            return this.pageable.getPageSize();
        }
        return this.content.size();
    }

    public int getNumberOfElements() {
        return this.content.size();
    }

    protected <U> List<U> getConvertedContent(Function<? super T, ? extends U> converter) {
        Assert.notNull(converter, (String)"Function must not be null");
        return this.stream().map(converter).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TarantoolChunk)) {
            return false;
        }
        TarantoolChunk that = (TarantoolChunk)o;
        return this.content.equals(that.content) && this.pageable.equals((Object)that.pageable);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.pageable);
    }
}

