/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data31;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.tarantool.client.crud.TarantoolCrudClient;
import io.tarantool.spring.data.ProxyTarantoolCrudKeyValueAdapter;
import io.tarantool.spring.data.mapping.model.CompositeKey;
import io.tarantool.spring.data31.TarantoolQueryEngine;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.keyvalue.core.AbstractKeyValueAdapter;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.NonNull;

public class TarantoolCrudKeyValueAdapter
extends AbstractKeyValueAdapter {
    private final ProxyTarantoolCrudKeyValueAdapter adapter;

    public TarantoolCrudKeyValueAdapter(@NonNull TarantoolCrudClient client) {
        super((QueryEngine)new TarantoolQueryEngine(client));
        this.adapter = new ProxyTarantoolCrudKeyValueAdapter(client);
    }

    public Object put(Object id, Object item, String keyspace) {
        return this.adapter.put(this.convertId(id), item, keyspace);
    }

    public boolean contains(Object id, String keyspace) {
        return this.adapter.contains(this.convertId(id), keyspace);
    }

    public Object get(Object id, String keyspace) {
        return this.adapter.get(this.convertId(id), keyspace);
    }

    public <T> T get(Object id, String keyspace, Class<T> type) {
        return (T)this.adapter.get(this.convertId(id), keyspace, type);
    }

    public Object delete(Object id, String keyspace) {
        return this.adapter.delete(this.convertId(id), keyspace);
    }

    public <T> T delete(Object id, String keyspace, Class<T> type) {
        return (T)this.adapter.delete(this.convertId(id), keyspace, type);
    }

    public Iterable<?> getAllOf(String keyspace) {
        return this.adapter.getAllOf(keyspace);
    }

    public void deleteAllOf(String keyspace) {
        this.adapter.deleteAllOf(keyspace);
    }

    public void clear() {
        this.adapter.clear();
    }

    public void destroy() throws Exception {
        this.adapter.destroy();
    }

    public long count(String keyspace) {
        return this.adapter.count(keyspace);
    }

    public CloseableIterator<Map.Entry<Object, Object>> entries(String keyspace) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private Object convertId(Object id) {
        if (id instanceof CompositeKey || this.hasJsonFormatArrayAnnotation(id)) {
            return id;
        }
        return Collections.singletonList(id);
    }

    private boolean hasJsonFormatArrayAnnotation(Object id) {
        JsonFormat jsonFormatAnnotation = (JsonFormat)AnnotatedElementUtils.findMergedAnnotation(id.getClass(), JsonFormat.class);
        return jsonFormatAnnotation != null && JsonFormat.Shape.ARRAY.equals((Object)jsonFormatAnnotation.shape());
    }
}

