/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data27.query;

import io.tarantool.spring.data27.query.TarantoolChunk;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.lang.NonNull;

class TarantoolSliceImpl<T>
extends TarantoolChunk<T> {
    private static final long serialVersionUID = 867755909294344406L;
    private final boolean hasNext;
    private final Pageable pageable;

    public TarantoolSliceImpl() {
        this(Collections.emptyList(), Pageable.unpaged(), false);
    }

    public TarantoolSliceImpl(List<T> content) {
        this(content, Pageable.unpaged(), false);
    }

    public TarantoolSliceImpl(List<T> content, Pageable pageable, boolean hasNext) {
        super(content, pageable);
        this.hasNext = this.hasContent() && hasNext;
        this.pageable = pageable;
    }

    public boolean hasNext() {
        return this.hasNext && this.hasContent();
    }

    @NonNull
    public <U> Slice<U> map(@NonNull Function<? super T, ? extends U> converter) {
        return new TarantoolSliceImpl<U>(this.getConvertedContent(converter), this.pageable, this.hasNext);
    }

    public String toString() {
        String contentType = "UNKNOWN";
        List content = this.getContent();
        if (content.size() > 0) {
            contentType = content.get(0).getClass().getName();
        }
        return String.format("Slice %d containing %s instances", this.getNumber(), contentType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TarantoolSliceImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TarantoolSliceImpl that = (TarantoolSliceImpl)o;
        return this.hasNext == that.hasNext && this.pageable.equals((Object)that.pageable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hasNext, this.pageable);
    }
}

