/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import io.tarantool.core.protocol.requests.SelectAfterMode;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class IProtoSelect
extends IProtoBaseRequest {
    private final Integer spaceId;
    private final String spaceName;
    private final Integer indexId;
    private final String indexName;
    private final int limit;
    private final int offset;
    private final int iterator;
    private final boolean fetchPosition;
    private final byte[] after;
    private final SelectAfterMode afterMode;
    private ArrayValue key;
    private byte[] rawKey;

    public IProtoSelect(Integer spaceId, String spaceName, Integer indexId, String indexName, int limit, int offset, int iterator, ArrayValue key, Long streamId, boolean fetchPosition, byte[] after, SelectAfterMode afterMode) {
        this.setStreamId(streamId);
        this.spaceId = spaceId;
        this.indexId = indexId;
        this.spaceName = spaceName;
        this.indexName = indexName;
        this.limit = limit;
        this.offset = offset;
        this.iterator = iterator;
        this.key = key;
        this.fetchPosition = fetchPosition;
        this.after = after;
        this.afterMode = afterMode;
    }

    public IProtoSelect(Integer spaceId, String spaceName, Integer indexId, String indexName, int limit, int offset, int iterator, byte[] key, Long streamId, boolean fetchPosition, byte[] after, SelectAfterMode afterMode) {
        this.setStreamId(streamId);
        this.spaceId = spaceId;
        this.indexId = indexId;
        this.spaceName = spaceName;
        this.indexName = indexName;
        this.limit = limit;
        this.offset = offset;
        this.iterator = iterator;
        this.rawKey = key;
        this.fetchPosition = fetchPosition;
        this.after = after;
        this.afterMode = afterMode;
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoConstant.RAW_IPROTO_TYPE_SELECT;
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException {
        this.preparePacker(packer);
        int items = 6;
        if (this.fetchPosition) {
            ++items;
        }
        if (this.after != null) {
            ++items;
        }
        switch (items) {
            case 7: {
                packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_SEVEN_ITEMS);
                break;
            }
            case 8: {
                packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_EIGHT_ITEMS);
                break;
            }
            default: {
                packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_SIX_ITEMS);
            }
        }
        if (this.spaceId != null) {
            packer.addPayload(IProtoConstant.RAW_IPROTO_SPACE_ID);
            packer.packInt(this.spaceId.intValue());
        } else {
            packer.addPayload(IProtoConstant.RAW_IPROTO_SPACE_NAME);
            packer.packString(this.spaceName);
        }
        if (this.indexId != null) {
            packer.addPayload(IProtoConstant.RAW_IPROTO_INDEX_ID);
            packer.packInt(this.indexId.intValue());
        } else {
            packer.addPayload(IProtoConstant.RAW_IPROTO_INDEX_NAME);
            packer.packString(this.indexName);
        }
        packer.addPayload(IProtoConstant.RAW_IPROTO_LIMIT);
        packer.packInt(this.limit);
        packer.addPayload(IProtoConstant.RAW_IPROTO_OFFSET);
        packer.packInt(this.offset);
        packer.addPayload(IProtoConstant.RAW_IPROTO_ITERATOR);
        packer.packInt(this.iterator);
        packer.addPayload(IProtoConstant.RAW_IPROTO_KEY);
        this.packValue(packer, this.rawKey, (Value)this.key);
        if (this.fetchPosition) {
            packer.addPayload(IProtoConstant.RAW_IPROTO_FETCH_POSITION);
            packer.packBoolean(true);
        }
        if (this.after != null) {
            if (this.afterMode != null && this.afterMode.equals((Object)SelectAfterMode.POSITION)) {
                packer.addPayload(IProtoConstant.RAW_IPROTO_AFTER_POSITION);
            } else {
                packer.addPayload(IProtoConstant.RAW_IPROTO_AFTER_TUPLE);
            }
            packer.addPayload(this.after);
        }
        return this.getPacketFromBase(packer);
    }

    @Override
    public MapValue getBody() {
        HashMap<Value, Object> map = new HashMap<Value, Object>();
        map.put(IProtoConstant.MP_IPROTO_SPACE_ID, ValueFactory.newInteger((int)this.spaceId));
        map.put(IProtoConstant.MP_IPROTO_SPACE_NAME, ValueFactory.newString((String)this.spaceName));
        map.put(IProtoConstant.MP_IPROTO_INDEX_ID, ValueFactory.newInteger((int)this.indexId));
        map.put(IProtoConstant.MP_IPROTO_INDEX_NAME, ValueFactory.newString((String)this.indexName));
        map.put(IProtoConstant.MP_IPROTO_LIMIT, ValueFactory.newInteger((int)this.limit));
        map.put(IProtoConstant.MP_IPROTO_OFFSET, ValueFactory.newInteger((int)this.offset));
        map.put(IProtoConstant.MP_IPROTO_ITERATOR, ValueFactory.newInteger((int)this.iterator));
        map.put(IProtoConstant.MP_IPROTO_KEY, this.key);
        return ValueFactory.newMap(map);
    }

    @Override
    public int getRequestType() {
        return 1;
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoSelect(syncId = ").append(this.getSyncId()).append(", spaceId = ").append(this.spaceId).append(", indexId = ").append(this.indexId).append(", spaceName = ").append(this.spaceName).append(", indexName = ").append(this.indexName).append(", limit = ").append(this.limit).append(", offset = ").append(this.offset).append(", iterator = ").append(this.iterator).append(", key = ").append(this.key != null ? this.key : Arrays.toString(this.rawKey)).append(", fetchPosition = ").append(this.fetchPosition).append(", after = ").append(Arrays.toString(this.after)).append(", afterMode = ").append((Object)this.afterMode).append(")");
        }
        return this.stringBuilder.toString();
    }
}

