/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class IProtoEval
extends IProtoBaseRequest {
    private final String expression;
    private ArrayValue args;
    private byte[] rawArgs;
    private byte[] rawFormats;

    public IProtoEval(String expression, ArrayValue args, Long streamId) {
        this.expression = expression;
        this.args = args;
        this.setStreamId(streamId);
    }

    public IProtoEval(String expression, byte[] args, Long streamId) {
        this.expression = expression;
        this.rawArgs = args;
        this.rawFormats = null;
        this.setStreamId(streamId);
    }

    public IProtoEval(String expression, byte[] args, byte[] formats, Long streamId) {
        this.expression = expression;
        this.rawArgs = args;
        this.rawFormats = formats;
        this.setStreamId(streamId);
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException {
        this.preparePacker(packer);
        if (this.rawFormats == null) {
            packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_TWO_ITEMS);
        } else {
            packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_THREE_ITEMS);
            packer.packInt(96);
            packer.addPayload(this.rawFormats);
        }
        packer.addPayload(IProtoConstant.RAW_IPROTO_EXPR);
        packer.packString(this.expression);
        packer.addPayload(IProtoConstant.RAW_IPROTO_TUPLE);
        this.packValue(packer, this.rawArgs, (Value)this.args);
        return this.getPacketFromBase(packer);
    }

    @Override
    public MapValue getBody() {
        if (this.args == null) {
            return null;
        }
        HashMap<Value, Object> map = new HashMap<Value, Object>();
        map.put(IProtoConstant.MP_IPROTO_EXPR, ValueFactory.newString((String)this.expression));
        map.put(IProtoConstant.MP_IPROTO_TUPLE, this.args);
        return ValueFactory.newMap(map);
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoConstant.RAW_IPROTO_TYPE_EVAL;
    }

    @Override
    public int getRequestType() {
        return 8;
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoEval(syncId = ").append(this.getSyncId()).append(", expr = ").append(this.expression).append(", args = ").append(this.args != null ? this.args : Arrays.toString(this.rawArgs)).append(")");
        }
        return this.stringBuilder.toString();
    }
}

