/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class IProtoDelete
extends IProtoBaseRequest {
    private final Integer spaceId;
    private final String spaceName;
    private final Integer indexId;
    private final String indexName;
    private Value key;
    private byte[] rawKey;

    public IProtoDelete(Integer spaceId, String spaceName, Integer indexId, String indexName, Value key, Long streamId) {
        this.spaceId = spaceId;
        this.key = key;
        this.indexId = indexId;
        this.spaceName = spaceName;
        this.indexName = indexName;
        this.setStreamId(streamId);
    }

    public IProtoDelete(Integer spaceId, String spaceName, Integer indexId, String indexName, byte[] key, Long streamId) {
        this.spaceId = spaceId;
        this.indexId = indexId;
        this.spaceName = spaceName;
        this.indexName = indexName;
        this.rawKey = key;
        this.setStreamId(streamId);
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException {
        this.preparePacker(packer);
        packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_THREE_ITEMS);
        if (this.spaceId != null) {
            packer.addPayload(IProtoConstant.RAW_IPROTO_SPACE_ID);
            packer.packInt(this.spaceId.intValue());
        } else {
            packer.addPayload(IProtoConstant.RAW_IPROTO_SPACE_NAME);
            packer.packString(this.spaceName);
        }
        if (this.indexId != null) {
            packer.addPayload(IProtoConstant.RAW_IPROTO_INDEX_ID);
            packer.packInt(this.indexId.intValue());
        } else {
            packer.addPayload(IProtoConstant.RAW_IPROTO_INDEX_NAME);
            packer.packString(this.indexName);
        }
        packer.addPayload(IProtoConstant.RAW_IPROTO_KEY);
        this.packValue(packer, this.rawKey, this.key);
        return this.getPacketFromBase(packer);
    }

    @Override
    public MapValue getBody() {
        if (this.key == null) {
            return null;
        }
        HashMap<Value, Object> map = new HashMap<Value, Object>();
        map.put(IProtoConstant.MP_IPROTO_SPACE_ID, ValueFactory.newInteger((int)this.spaceId));
        map.put(IProtoConstant.MP_IPROTO_SPACE_NAME, ValueFactory.newString((String)this.spaceName));
        map.put(IProtoConstant.MP_IPROTO_INDEX_ID, ValueFactory.newInteger((int)this.indexId));
        map.put(IProtoConstant.MP_IPROTO_INDEX_NAME, ValueFactory.newString((String)this.indexName));
        map.put(IProtoConstant.MP_IPROTO_KEY, this.key);
        return ValueFactory.newMap(map);
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoConstant.RAW_IPROTO_TYPE_DELETE;
    }

    @Override
    public int getRequestType() {
        return 5;
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoDelete(syncId = ").append(this.getSyncId()).append(", spaceId = ").append(this.spaceId).append(", indexId = ").append(this.indexId).append(", spaceName = ").append(this.spaceName).append(", indexName = ").append(this.indexName).append(", key = ").append(this.key != null ? this.key : Arrays.toString(this.rawKey)).append(")");
        }
        return this.stringBuilder.toString();
    }
}

