/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class IProtoCall
extends IProtoBaseRequest {
    private final String functionName;
    private ArrayValue args;
    private byte[] rawArgs;
    private byte[] rawFormats;

    public IProtoCall(String functionName, ArrayValue args, Long streamId) {
        this.functionName = functionName;
        this.args = args;
        this.setStreamId(streamId);
    }

    public IProtoCall(String functionName, byte[] args, byte[] formats, Long streamId) {
        this.functionName = functionName;
        this.rawArgs = args;
        this.rawFormats = formats;
        this.setStreamId(streamId);
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException {
        this.preparePacker(packer);
        if (this.rawFormats == null) {
            packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_TWO_ITEMS);
        } else {
            packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_THREE_ITEMS);
            packer.packInt(96);
            packer.addPayload(this.rawFormats);
        }
        packer.addPayload(IProtoConstant.RAW_IPROTO_FUNCTION_NAME);
        packer.packString(this.functionName);
        packer.addPayload(IProtoConstant.RAW_IPROTO_TUPLE);
        this.packValue(packer, this.rawArgs, (Value)this.args);
        return this.getPacketFromBase(packer);
    }

    @Override
    public MapValue getBody() {
        if (this.args == null) {
            return null;
        }
        HashMap<Value, Object> map = new HashMap<Value, Object>();
        map.put(IProtoConstant.MP_IPROTO_FUNCTION_NAME, ValueFactory.newString((String)this.functionName));
        map.put(IProtoConstant.MP_IPROTO_TUPLE, this.args);
        return ValueFactory.newMap(map);
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoConstant.RAW_IPROTO_TYPE_CALL;
    }

    @Override
    public int getRequestType() {
        return 10;
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoCall(syncId = ").append(this.getSyncId()).append(", function = ").append(this.functionName).append(", args = ").append(this.args != null ? this.args : Arrays.toString(this.rawArgs)).append(")");
        }
        return this.stringBuilder.toString();
    }
}

