/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.MapValue;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class IProtoAuth
extends IProtoBaseRequest {
    public static final AuthType DEFAULT_AUTH_TYPE = AuthType.CHAP_SHA1;
    private final AuthType authType;
    private final String user;
    private final String password;
    private final byte[] salt;

    public IProtoAuth(String user, String password, byte[] salt, AuthType authType) {
        this.user = user;
        this.password = password;
        this.salt = salt;
        this.authType = authType;
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException, NoSuchAlgorithmException {
        this.preparePacker(packer);
        packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_TWO_ITEMS);
        packer.addPayload(IProtoConstant.RAW_IPROTO_USER_NAME);
        packer.packString(this.user);
        packer.addPayload(IProtoConstant.RAW_IPROTO_TUPLE);
        if (this.authType == AuthType.PAP_SHA256) {
            packer.packValue((Value)ValueFactory.newArray((Value[])new Value[]{this.authType.getRawAuthTypeName(), ValueFactory.newString((String)this.password)}));
        } else {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] step1 = sha1.digest(this.password.getBytes());
            byte[] step2 = sha1.digest(step1);
            sha1.update(this.salt, 0, 20);
            sha1.update(step2);
            byte[] scramble = sha1.digest();
            for (int i = 0; i < 20; ++i) {
                int n = i;
                scramble[n] = (byte)(scramble[n] ^ step1[i]);
            }
            packer.packValue((Value)ValueFactory.newArray((Value[])new Value[]{this.authType.getRawAuthTypeName(), ValueFactory.newBinary((byte[])scramble)}));
        }
        return this.getPacketFromBase(packer);
    }

    @Override
    public MapValue getBody() throws Exception {
        HashMap<Value, Object> map = new HashMap<Value, Object>();
        map.put(IProtoConstant.MP_IPROTO_USER_NAME, ValueFactory.newString((String)this.user));
        if (this.authType == AuthType.PAP_SHA256) {
            map.put(IProtoConstant.MP_IPROTO_TUPLE, ValueFactory.newArray((Value[])new Value[]{ValueFactory.newString((String)this.authType.toString()), ValueFactory.newString((String)this.password)}));
        } else {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] step1 = sha1.digest(this.password.getBytes());
            byte[] step2 = sha1.digest(step1);
            sha1.update(this.salt, 0, 20);
            sha1.update(step2);
            byte[] scramble = sha1.digest();
            for (int i = 0; i < 20; ++i) {
                int n = i;
                scramble[n] = (byte)(scramble[n] ^ step1[i]);
            }
            map.put(IProtoConstant.MP_IPROTO_TUPLE, ValueFactory.newArray((Value[])new Value[]{ValueFactory.newString((String)this.authType.toString()), ValueFactory.newBinary((byte[])scramble)}));
        }
        return ValueFactory.newMap(map);
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoConstant.RAW_IPROTO_TYPE_AUTH;
    }

    @Override
    public int getRequestType() {
        return 7;
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoAuth(syncId = ").append(this.getSyncId()).append(", user = ").append(this.user).append(", authType = ").append((Object)this.authType).append(")");
        }
        return this.stringBuilder.toString();
    }

    public static enum AuthType {
        CHAP_SHA1("chap-sha1"),
        PAP_SHA256("pap-sha256");

        private final String authTypeName;
        private final StringValue rawAuthTypeName;

        private AuthType(String authTypeName) {
            this.authTypeName = authTypeName;
            this.rawAuthTypeName = ValueFactory.newString((String)authTypeName);
        }

        public String toString() {
            return this.authTypeName;
        }

        public StringValue getRawAuthTypeName() {
            return this.rawAuthTypeName;
        }
    }
}

