/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.exceptions;

import io.tarantool.core.exceptions.BoxErrorStackItem;
import io.tarantool.core.protocol.IProtoMessage;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.util.List;
import java.util.stream.Collectors;
import org.msgpack.value.Value;

public class BoxError
extends RuntimeException {
    private static final long serialVersionUID = -407469439059293836L;
    private final int code;
    private final String tarantoolMessage;
    private final List<BoxErrorStackItem> stack;
    private StringBuilder sb;

    public static BoxError fromIProtoMessage(IProtoMessage packet) {
        return new BoxError(packet.getErrorCode(), packet.getBodyStringValue(49).asString(), ((Value)packet.getBodyMapValue(82).map().get(IProtoConstant.MP_ERROR_STACK)).asArrayValue().list().stream().map(Value::asMapValue).map(BoxErrorStackItem::fromStruct).collect(Collectors.toList()));
    }

    private BoxError(int code, String tarantoolMessage, List<BoxErrorStackItem> stack) {
        this.code = code;
        this.tarantoolMessage = tarantoolMessage;
        this.stack = stack;
    }

    @Override
    public String getMessage() {
        if (this.sb == null) {
            this.sb = new StringBuilder("BoxError{").append("code=").append(this.code).append(", message='").append(this.tarantoolMessage).append('\'').append(", stack=").append(this.stack).append('}');
        }
        return this.sb.toString();
    }

    public String getTarantoolMessage() {
        return this.tarantoolMessage;
    }

    public List<BoxErrorStackItem> getTarantoolStack() {
        return this.stack;
    }

    public int getErrorCode() {
        return this.code;
    }
}

