/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.connection;

import io.netty.bootstrap.Bootstrap;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.Timer;
import io.tarantool.core.connection.Connection;
import io.tarantool.core.connection.ConnectionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory {
    private final Bootstrap bootstrap;
    private final Timer timerService;
    private SslContext sslContext;
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactory.class);

    public ConnectionFactory(Bootstrap bootstrap, Timer timerService) {
        this.bootstrap = bootstrap;
        this.timerService = timerService;
    }

    public ConnectionFactory(Bootstrap bootstrap, SslContext sslContext, Timer timerService) {
        this.bootstrap = bootstrap;
        this.sslContext = sslContext;
        this.timerService = timerService;
    }

    public Connection create() {
        return new ConnectionImpl(this.bootstrap.clone(), this.sslContext, this.timerService, null);
    }

    public Connection create(FlushConsolidationHandler flushConsolidationHandler) {
        return new ConnectionImpl(this.bootstrap.clone(), this.sslContext, this.timerService, flushConsolidationHandler);
    }

    public Timer getTimerService() {
        return this.timerService;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }
}

