/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core;

import java.util.function.BiConsumer;

public final class WatcherOptions {
    private long sendTimeout;
    private BiConsumer<String, Throwable> errorHandler;

    public static Builder builder() {
        return new Builder();
    }

    private WatcherOptions(long timeout, BiConsumer<String, Throwable> errback) {
        this.sendTimeout = timeout;
        this.errorHandler = errback;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public BiConsumer<String, Throwable> getErrorHandler() {
        return this.errorHandler;
    }

    public static class Builder {
        private long sendTimeout = 5000L;
        private BiConsumer<String, Throwable> errorHandler = (key, err) -> {};

        public Builder withErrorHandler(BiConsumer<String, Throwable> errback) {
            this.errorHandler = errback;
            return this;
        }

        public Builder withSendTimeout(long timeout) {
            this.sendTimeout = timeout;
            return this;
        }

        public WatcherOptions build() {
            return new WatcherOptions(this.sendTimeout, this.errorHandler);
        }
    }
}

