/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.factory;

import com.fasterxml.jackson.core.type.TypeReference;
import io.tarantool.balancer.TarantoolBalancer;
import io.tarantool.client.BaseOptions;
import io.tarantool.client.Options;
import io.tarantool.client.box.TarantoolBoxSpace;
import io.tarantool.client.box.options.DeleteOptions;
import io.tarantool.client.box.options.OptionsWithIndex;
import io.tarantool.client.box.options.SelectOptions;
import io.tarantool.client.box.options.UpdateOptions;
import io.tarantool.client.factory.TarantoolSpace;
import io.tarantool.client.operation.Operations;
import io.tarantool.core.IProtoFeature;
import io.tarantool.core.protocol.IProtoRequestOpts;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.core.protocol.requests.SelectAfterMode;
import io.tarantool.mapping.SelectResponse;
import io.tarantool.mapping.TarantoolJacksonMapping;
import io.tarantool.mapping.TarantoolResponse;
import io.tarantool.mapping.Tuple;
import io.tarantool.pool.IProtoClientPool;
import io.tarantool.schema.Index;
import io.tarantool.schema.NoSchemaException;
import io.tarantool.schema.Space;
import io.tarantool.schema.TarantoolSchemaFetcher;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class TarantoolBoxSpaceImpl
extends TarantoolSpace
implements TarantoolBoxSpace {
    private static final SelectOptions defaultSelectOptions = SelectOptions.builder().build();
    private static final DeleteOptions defaultDeleteOptions = DeleteOptions.builder().build();
    private static final UpdateOptions defaultUpdateOptions = UpdateOptions.builder().build();
    private static final Options defaultOptions = BaseOptions.builder().build();
    private final TarantoolSchemaFetcher fetcher;
    private final TarantoolBalancer balancer;
    private Integer spaceId;
    private String spaceName;
    private Space space;

    TarantoolBoxSpaceImpl(TarantoolBalancer balancer, Integer spaceId, TarantoolSchemaFetcher fetcher) {
        this.balancer = balancer;
        this.fetcher = fetcher;
        Objects.requireNonNull(spaceId, "spaceId must be not null");
        this.spaceId = spaceId;
        if (fetcher != null) {
            this.space = fetcher.getSpace(spaceId);
        }
    }

    TarantoolBoxSpaceImpl(TarantoolBalancer balancer, String spaceName, TarantoolSchemaFetcher fetcher) {
        this.balancer = balancer;
        this.fetcher = fetcher;
        Objects.requireNonNull(spaceName, "spaceName must be not null");
        this.spaceName = spaceName;
        if (fetcher != null) {
            this.space = fetcher.getSpace(spaceName);
            this.spaceId = this.space.getId();
        }
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> insert(Object tuple) {
        return this.insert(tuple, defaultOptions);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> insert(Object tuple, Options options) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoInsert(tuple, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> insert(Object tuple, Class<T> entity) {
        return this.insert(tuple, defaultOptions, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> insert(Object tuple, Options options, Class<T> entity) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoInsert(tuple, options), entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<Tuple<T>>> insert(Object tuple, TypeReference<T> entity) {
        return this.insert(tuple, defaultOptions, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<Tuple<T>>> insert(Object tuple, Options options, TypeReference<T> entity) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoInsert(tuple, options), entity);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> replace(Object tuple) {
        return this.replace(tuple, defaultOptions);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> replace(Object tuple, Options options) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoReplace(tuple, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> replace(Object tuple, Class<T> entity) {
        return this.replace(tuple, defaultOptions, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> replace(Object tuple, Options options, Class<T> entity) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoReplace(tuple, options), entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<Tuple<T>>> replace(Object tuple, TypeReference<T> entity) {
        return this.replace(tuple, defaultOptions, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<Tuple<T>>> replace(Object tuple, Options options, TypeReference<T> entity) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoReplace(tuple, options), entity);
    }

    @Override
    public CompletableFuture<SelectResponse<List<Tuple<List<?>>>>> select(List<?> key) {
        return this.select(key, defaultSelectOptions);
    }

    @Override
    public CompletableFuture<SelectResponse<List<Tuple<List<?>>>>> select(Object ... key) {
        return this.select(Arrays.asList(key), defaultSelectOptions);
    }

    @Override
    public CompletableFuture<SelectResponse<List<Tuple<List<?>>>>> select(List<?> key, SelectOptions options) {
        return TarantoolJacksonMapping.convertSelectResultFuture(this.iprotoSelect(key, options));
    }

    @Override
    public <T> CompletableFuture<SelectResponse<List<Tuple<T>>>> select(List<?> key, Class<T> entity) {
        return this.select(key, defaultSelectOptions, entity);
    }

    @Override
    public <T> CompletableFuture<SelectResponse<List<Tuple<T>>>> select(List<?> key, SelectOptions options, Class<T> entity) {
        return TarantoolJacksonMapping.convertSelectResultFuture(this.iprotoSelect(key, options), entity);
    }

    @Override
    public <T> CompletableFuture<SelectResponse<T>> select(List<?> key, TypeReference<T> entity) {
        return this.select(key, defaultSelectOptions, entity);
    }

    @Override
    public <T> CompletableFuture<SelectResponse<T>> select(List<?> key, SelectOptions options, TypeReference<T> entity) {
        return TarantoolJacksonMapping.convertSelectResultFuture(this.iprotoSelect(key, options), entity);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> delete(List<?> key) {
        return this.delete(key, defaultDeleteOptions);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> delete(Object ... key) {
        return this.delete(Arrays.asList(key), defaultDeleteOptions);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> delete(List<?> key, DeleteOptions options) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoDelete(key, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> delete(List<?> key, Class<T> entity) {
        return this.delete(key, defaultDeleteOptions, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> delete(List<?> key, DeleteOptions options, Class<T> entity) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoDelete(key, options), entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<Tuple<T>>> delete(List<?> key, TypeReference<T> entity) {
        return this.delete(key, defaultDeleteOptions, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<Tuple<T>>> delete(List<?> key, DeleteOptions options, TypeReference<T> entity) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoDelete(key, options), entity);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> update(List<?> key, List<List<?>> operations) {
        return this.update(key, operations, defaultUpdateOptions);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> update(List<?> key, Operations operations) {
        return this.update(key, operations, defaultUpdateOptions);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> update(List<?> key, List<List<?>> operations, UpdateOptions options) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoUpdate(key, operations, options));
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> update(List<?> key, Operations operations, UpdateOptions options) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoUpdate(key, operations, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> update(List<?> key, List<List<?>> operations, Class<T> entity) {
        return this.update(key, operations, defaultUpdateOptions, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> update(List<?> key, Operations operations, Class<T> entity) {
        return this.update(key, operations, defaultUpdateOptions, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> update(List<?> key, List<List<?>> operations, UpdateOptions options, Class<T> entity) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoUpdate(key, operations, options), entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> update(List<?> key, Operations operations, UpdateOptions options, Class<T> entity) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoUpdate(key, operations, options), entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<Tuple<T>>> update(List<?> key, List<List<?>> operations, TypeReference<T> entity) {
        return this.update(key, operations, defaultUpdateOptions, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<Tuple<T>>> update(List<?> key, Operations operations, TypeReference<T> entity) {
        return this.update(key, operations, defaultUpdateOptions, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<Tuple<T>>> update(List<?> key, List<List<?>> operations, UpdateOptions options, TypeReference<T> entity) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoUpdate(key, operations, options), entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<Tuple<T>>> update(List<?> key, Operations operations, UpdateOptions options, TypeReference<T> entity) {
        return TarantoolJacksonMapping.convertSpaceSingleResultFuture(this.iprotoUpdate(key, operations, options), entity);
    }

    @Override
    public CompletableFuture<Void> upsert(Object tuple, List<List<?>> operations) {
        return this.upsert(tuple, operations, defaultUpdateOptions);
    }

    @Override
    public CompletableFuture<Void> upsert(Object tuple, Operations operations) {
        return this.upsert(tuple, operations, defaultUpdateOptions);
    }

    @Override
    public CompletableFuture<Void> upsert(Object tuple, List<List<?>> operations, UpdateOptions options) {
        return this.iprotoUpsert(tuple, operations, options).thenAccept(r -> {});
    }

    @Override
    public CompletableFuture<Void> upsert(Object tuple, Operations operations, UpdateOptions options) {
        return this.iprotoUpsert(tuple, operations, options).thenAccept(r -> {});
    }

    @Override
    public TarantoolSchemaFetcher getFetcher() {
        return this.fetcher;
    }

    private CompletableFuture<IProtoResponse> iprotoUpsert(Object tuple, List<?> operations, UpdateOptions options) {
        if (tuple == null) {
            throw new IllegalArgumentException("tuple can't be null");
        }
        if (operations == null) {
            throw new IllegalArgumentException("operations can't be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        CompletionStage requestFuture = this.balancer.getNext().thenCompose(client -> {
            int indexId;
            IProtoRequestOpts requestOpts = IProtoRequestOpts.empty().withRequestTimeout(options.getTimeout()).withStreamId(options.getStreamId());
            if (this.fetcher != null) {
                indexId = this.getIndexIdWithEnabledFetcher(options);
            } else {
                this.assertSpaceName(client.isFeatureEnabled(IProtoFeature.SPACE_AND_INDEX_NAMES));
                this.assertIndexName(options);
                indexId = options.getIndexId();
            }
            return client.upsert(this.spaceId, this.spaceName, Integer.valueOf(indexId), TarantoolJacksonMapping.toValue((Object)tuple), TarantoolJacksonMapping.toValue((Object)operations), requestOpts);
        });
        if (this.fetcher != null) {
            return this.fetcher.processRequest((CompletableFuture)requestFuture);
        }
        return requestFuture;
    }

    private CompletableFuture<IProtoResponse> iprotoUpdate(List<?> key, List<?> operations, UpdateOptions options) {
        if (key == null) {
            throw new IllegalArgumentException("key can't be null");
        }
        if (operations == null) {
            throw new IllegalArgumentException("operations can't be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        CompletionStage requestFuture = this.balancer.getNext().thenCompose(client -> {
            Integer indexId;
            IProtoRequestOpts requestOpts = IProtoRequestOpts.empty().withRequestTimeout(options.getTimeout()).withStreamId(options.getStreamId());
            String indexName = null;
            if (this.fetcher != null) {
                indexId = this.getIndexIdWithEnabledFetcher(options);
            } else {
                boolean serverHasMetaNamesFeature = client.isFeatureEnabled(IProtoFeature.SPACE_AND_INDEX_NAMES);
                this.assertSpaceName(serverHasMetaNamesFeature);
                this.assertIndexName(options, serverHasMetaNamesFeature);
                indexName = options.getIndexName();
                indexId = this.getIndexIdDependingOnPriority(options, serverHasMetaNamesFeature);
            }
            return client.update(this.spaceId, this.spaceName, indexId, indexName, TarantoolJacksonMapping.toValue((Object)key), TarantoolJacksonMapping.toValue((Object)operations), requestOpts);
        });
        if (this.fetcher != null) {
            return this.fetcher.processRequest((CompletableFuture)requestFuture);
        }
        return requestFuture;
    }

    private CompletableFuture<IProtoResponse> iprotoDelete(List<?> key, DeleteOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        CompletionStage requestFuture = this.balancer.getNext().thenCompose(client -> {
            Integer indexId;
            IProtoRequestOpts requestOpts = IProtoRequestOpts.empty().withRequestTimeout(options.getTimeout()).withStreamId(options.getStreamId());
            String indexName = null;
            if (this.fetcher != null) {
                indexId = this.getIndexIdWithEnabledFetcher(options);
            } else {
                boolean serverHasMetaNamesFeature = client.isFeatureEnabled(IProtoFeature.SPACE_AND_INDEX_NAMES);
                this.assertSpaceName(serverHasMetaNamesFeature);
                this.assertIndexName(options, serverHasMetaNamesFeature);
                indexName = options.getIndexName();
                indexId = this.getIndexIdDependingOnPriority(options, serverHasMetaNamesFeature);
            }
            return client.delete(this.spaceId, this.spaceName, indexId, indexName, TarantoolJacksonMapping.toValue((Object)key), requestOpts);
        });
        if (this.fetcher != null) {
            return this.fetcher.processRequest((CompletableFuture)requestFuture);
        }
        return requestFuture;
    }

    private CompletableFuture<IProtoResponse> iprotoSelect(List<?> key, SelectOptions options) {
        byte[] castedAfter;
        SelectAfterMode afterMode;
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        Object after = options.getAfter();
        if (after instanceof byte[]) {
            afterMode = SelectAfterMode.POSITION;
            castedAfter = (byte[])after;
        } else if (after != null) {
            afterMode = SelectAfterMode.TUPLE;
            castedAfter = TarantoolJacksonMapping.toValue((Object)after);
        } else {
            afterMode = null;
            castedAfter = null;
        }
        CompletionStage requestFuture = this.balancer.getNext().thenCompose(client -> {
            Integer indexId;
            IProtoRequestOpts requestOpts = IProtoRequestOpts.empty().withRequestTimeout(options.getTimeout()).withStreamId(options.getStreamId());
            String indexName = null;
            if (this.fetcher != null) {
                indexId = this.getIndexIdWithEnabledFetcher(options);
            } else {
                boolean serverHasMetaNamesFeature = client.isFeatureEnabled(IProtoFeature.SPACE_AND_INDEX_NAMES);
                this.assertSpaceName(serverHasMetaNamesFeature);
                this.assertIndexName(options, serverHasMetaNamesFeature);
                indexName = options.getIndexName();
                indexId = this.getIndexIdDependingOnPriority(options, serverHasMetaNamesFeature);
            }
            return client.select(this.spaceId, this.spaceName, indexId, indexName, TarantoolJacksonMapping.toValue((Object)key), options.getLimit(), options.getOffset(), options.getIterator(), options.isPositionFetchEnabled(), castedAfter, afterMode, requestOpts);
        });
        if (this.fetcher != null) {
            return this.fetcher.processRequest((CompletableFuture)requestFuture);
        }
        return requestFuture;
    }

    private CompletableFuture<IProtoResponse> iprotoReplace(Object tuple, Options options) {
        if (tuple == null) {
            throw new IllegalArgumentException("tuple can't be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        CompletionStage requestFuture = this.balancer.getNext().thenCompose(client -> {
            IProtoRequestOpts requestOpts = IProtoRequestOpts.empty().withRequestTimeout(options.getTimeout()).withStreamId(options.getStreamId());
            if (this.fetcher == null) {
                this.assertSpaceName(client.isFeatureEnabled(IProtoFeature.SPACE_AND_INDEX_NAMES));
            }
            return client.replace(this.spaceId, this.spaceName, TarantoolJacksonMapping.toValue((Object)tuple), requestOpts);
        });
        if (this.fetcher != null) {
            return this.fetcher.processRequest((CompletableFuture)requestFuture);
        }
        return requestFuture;
    }

    private CompletableFuture<IProtoResponse> iprotoInsert(Object tuple, Options options) {
        if (tuple == null) {
            throw new IllegalArgumentException("tuple can't be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        CompletionStage requestFuture = this.balancer.getNext().thenCompose(client -> {
            IProtoRequestOpts requestOpts = IProtoRequestOpts.empty().withRequestTimeout(options.getTimeout()).withStreamId(options.getStreamId());
            if (this.fetcher == null) {
                this.assertSpaceName(client.isFeatureEnabled(IProtoFeature.SPACE_AND_INDEX_NAMES));
            }
            return client.insert(this.spaceId, this.spaceName, TarantoolJacksonMapping.toValue((Object)tuple), requestOpts);
        });
        if (this.fetcher != null) {
            return this.fetcher.processRequest((CompletableFuture)requestFuture);
        }
        return requestFuture;
    }

    private void assertSpaceName(boolean serverHasMetaNamesFeature) throws IllegalArgumentException {
        if (!serverHasMetaNamesFeature && this.spaceName != null) {
            throw new IllegalArgumentException("Can't use space or index names without enabled fetchSchema option for Tarantool version < 3.0.0");
        }
    }

    private void assertIndexName(OptionsWithIndex options, boolean serverHasMetaNamesFeature) throws IllegalArgumentException {
        if (!serverHasMetaNamesFeature && options.getIndexName() != null) {
            throw new IllegalArgumentException("Can't use space or index names without enabled fetchSchema option for Tarantool version < 3.0.0");
        }
    }

    private void assertIndexName(OptionsWithIndex options) throws IllegalArgumentException {
        if (options.getIndexName() != null) {
            throw new IllegalArgumentException("Can't use space or index names without enabled fetchSchema option for Tarantool version < 3.0.0");
        }
    }

    private Integer getIndexIdDependingOnPriority(OptionsWithIndex options, boolean serverHasMetaNamesFeature) {
        if (serverHasMetaNamesFeature && options.getIndexName() != null) {
            return null;
        }
        return options.getIndexId();
    }

    private int getIndexIdWithEnabledFetcher(OptionsWithIndex options) {
        String indexName = options.getIndexName();
        if (indexName == null) {
            return options.getIndexId();
        }
        Index index = this.space.getIndex(indexName);
        if (index == null) {
            this.space = this.spaceName == null ? this.fetcher.getSpace(this.spaceId) : this.fetcher.getSpace(this.spaceName);
            index = this.space.getIndex(indexName);
            if (index == null) {
                throw new NoSchemaException("No index " + indexName + " for space: " + this.space.getName());
            }
        }
        return index.getIndexId();
    }

    @Override
    public TarantoolBalancer getBalancer() {
        return this.balancer;
    }

    @Override
    public IProtoClientPool getPool() {
        return this.balancer.getPool();
    }
}

