/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.schema;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.tarantool.mapping.Field;
import io.tarantool.schema.Index;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
public class Space {
    int id;
    int owner;
    String name;
    String engine;
    int fieldCount;
    Map<String, Object> flags;
    List<Field> format;
    Map<String, Index> indexes = new HashMap<String, Index>();

    public int getId() {
        return this.id;
    }

    public Space setId(int id) {
        this.id = id;
        return this;
    }

    public int getOwner() {
        return this.owner;
    }

    public Space setOwner(int owner) {
        this.owner = owner;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Space setName(String name) {
        this.name = name;
        return this;
    }

    public String getEngine() {
        return this.engine;
    }

    public Space setEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public Space setFieldCount(int fieldCount) {
        this.fieldCount = fieldCount;
        return this;
    }

    public Map<String, Object> getFlags() {
        return this.flags;
    }

    public Space setFlags(Map<String, Object> flags) {
        this.flags = flags;
        return this;
    }

    public List<Field> getFormat() {
        return this.format;
    }

    public Space setFormat(List<Field> format) {
        this.format = format;
        return this;
    }

    public Index getIndex(String name) {
        return this.indexes.get(name);
    }

    public Space addIndex(Index index) {
        this.indexes.put(index.getName(), index);
        return this;
    }

    public Map<String, Index> getIndexes() {
        return this.indexes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Space space = (Space)o;
        if (this.id != space.id) {
            return false;
        }
        if (this.owner != space.owner) {
            return false;
        }
        if (this.fieldCount != space.fieldCount) {
            return false;
        }
        if (!Objects.equals(this.name, space.name)) {
            return false;
        }
        if (!Objects.equals(this.engine, space.engine)) {
            return false;
        }
        if (!Objects.equals(this.flags, space.flags)) {
            return false;
        }
        if (!Objects.equals(this.format, space.format)) {
            return false;
        }
        return Objects.equals(this.indexes, space.indexes);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.owner;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
        result = 31 * result + this.fieldCount;
        result = 31 * result + (this.flags != null ? this.flags.hashCode() : 0);
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        result = 31 * result + (this.indexes != null ? this.indexes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Space{id=" + this.id + ", owner=" + this.owner + ", name='" + this.name + '\'' + ", engine='" + this.engine + '\'' + ", fieldCount=" + this.fieldCount + ", flags=" + this.flags + ", format=" + this.format + ", indexes=" + this.indexes + '}';
    }
}

