/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class IProtoInsert
extends IProtoBaseRequest {
    protected final Integer spaceId;
    protected final String spaceName;
    protected ArrayValue tuple;
    protected byte[] rawTuple;

    public IProtoInsert(Integer spaceId, String spaceName, ArrayValue tuple, Long streamId) {
        this.spaceId = spaceId;
        this.spaceName = spaceName;
        this.tuple = tuple;
        this.setStreamId(streamId);
    }

    public IProtoInsert(Integer spaceId, String spaceName, byte[] tuple, Long streamId) {
        this.spaceId = spaceId;
        this.spaceName = spaceName;
        this.rawTuple = tuple;
        this.setStreamId(streamId);
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException {
        this.preparePacker(packer);
        packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_TWO_ITEMS);
        if (this.spaceId != null) {
            packer.addPayload(IProtoConstant.RAW_IPROTO_SPACE_ID);
            packer.packInt(this.spaceId.intValue());
        } else {
            packer.addPayload(IProtoConstant.RAW_IPROTO_SPACE_NAME);
            packer.packString(this.spaceName);
        }
        packer.addPayload(IProtoConstant.RAW_IPROTO_TUPLE);
        this.packValue(packer, this.rawTuple, (Value)this.tuple);
        return this.getPacketFromBase(packer);
    }

    @Override
    public MapValue getBody() throws Exception {
        if (this.tuple == null) {
            return null;
        }
        HashMap<Value, Object> map = new HashMap<Value, Object>();
        map.put(IProtoConstant.MP_IPROTO_SPACE_ID, ValueFactory.newInteger((int)this.spaceId));
        map.put(IProtoConstant.MP_IPROTO_SPACE_NAME, ValueFactory.newString((String)this.spaceName));
        map.put(IProtoConstant.MP_IPROTO_TUPLE, this.tuple);
        return ValueFactory.newMap(map);
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoConstant.RAW_IPROTO_TYPE_INSERT;
    }

    @Override
    public int getRequestType() {
        return 2;
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoInsert(syncId = ").append(this.getSyncId()).append(", tuple = ").append(this.tuple != null ? this.tuple : Arrays.toString(this.rawTuple)).append(")");
        }
        return this.stringBuilder.toString();
    }
}

