/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.TransactionIsolationLevel;
import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.io.IOException;
import java.util.HashMap;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.ImmutableIntegerValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class IProtoBegin
extends IProtoBaseRequest {
    private final long timeout;
    private final TransactionIsolationLevel level;

    public IProtoBegin(Long streamId, long timeout, TransactionIsolationLevel level) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout should be greater than 0");
        }
        this.timeout = timeout;
        this.level = level;
        this.setStreamId(streamId);
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException {
        this.preparePacker(packer);
        int argsCounter = 1;
        if (!this.level.equals((Object)TransactionIsolationLevel.DEFAULT)) {
            ++argsCounter;
        }
        if (argsCounter == 2) {
            packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_TWO_ITEMS);
        } else {
            packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_ONE_ITEM);
        }
        packer.addPayload(IProtoConstant.RAW_IPROTO_TIMEOUT);
        packer.packDouble((double)this.timeout);
        if (!this.level.equals((Object)TransactionIsolationLevel.DEFAULT)) {
            packer.addPayload(IProtoConstant.RAW_IPROTO_TXN_ISOLATION);
            packer.packInt(this.level.ordinal());
        }
        return this.getPacketFromBase(packer);
    }

    @Override
    public MapValue getBody() {
        HashMap<Value, ImmutableIntegerValue> map = new HashMap<Value, ImmutableIntegerValue>();
        map.put(IProtoConstant.MP_IPROTO_TIMEOUT, ValueFactory.newInteger((long)this.timeout));
        if (!this.level.equals((Object)TransactionIsolationLevel.DEFAULT)) {
            map.put(IProtoConstant.MP_IPROTO_TXN_ISOLATION, ValueFactory.newInteger((int)this.level.ordinal()));
        }
        return ValueFactory.newMap(map);
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoConstant.RAW_IPROTO_TYPE_BEGIN;
    }

    @Override
    public int getRequestType() {
        return 14;
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoBegin(syncId = ").append(this.getSyncId()).append(", timeout = ").append(this.timeout).append(", level = ").append((Object)this.level).append(")");
        }
        return this.stringBuilder.toString();
    }
}

