/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol;

import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.IntegerValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;

public class IProtoRequestImpl
extends IProtoBaseRequest {
    private StringBuilder stringBuilder;
    protected MapValue header;
    protected MapValue body;
    protected Map<Integer, Value> headerMap;
    protected int requestType;
    protected Map<Integer, Value> bodyMap;

    public IProtoRequestImpl() {
    }

    public IProtoRequestImpl(MapValue header, MapValue body) {
        this.header = header;
        this.headerMap = IProtoRequestImpl.convertMap(header);
        this.body = body;
        this.bodyMap = IProtoRequestImpl.convertMap(body);
        this.syncId = this.headerMap.containsKey(1) ? this.headerMap.get(1).asIntegerValue().asLong() : -1L;
        this.requestType = this.headerMap.get(0).asIntegerValue().asInt();
    }

    protected static Map<Integer, Value> convertMap(MapValue map) {
        return map.map().entrySet().stream().collect(Collectors.toMap(e -> ((IntegerValue)e.getKey()).asInt(), Map.Entry::getValue));
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoRequestImpl(header = ").append(this.getHeader().toJson()).append(", body = ").append(this.getBody().toJson()).append(")");
        }
        return this.stringBuilder.toString();
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException {
        this.preparePacker(packer);
        packer.packValue((Value)this.body);
        return this.getPacketFromBase(packer);
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoRequestImpl.packType(this.requestType);
    }

    @Override
    public MapValue getBody() {
        return this.body;
    }

    @Override
    public MapValue getHeader() {
        return this.header;
    }

    @Override
    public long getSyncId() {
        if (!this.hasSyncId()) {
            return -1L;
        }
        return this.syncId;
    }

    @Override
    public void setSyncId(long syncId) {
        this.syncId = syncId;
    }

    @Override
    public int getErrorCode() {
        return this.getRequestType() - 32768;
    }

    @Override
    public Value getBodyValue(int key) {
        return this.bodyMap.get(key);
    }

    @Override
    public ArrayValue getBodyArrayValue(int key) {
        return this.getBodyValue(key).asArrayValue();
    }

    @Override
    public MapValue getBodyMapValue(int key) {
        return this.getBodyValue(key).asMapValue();
    }

    @Override
    public StringValue getBodyStringValue(int key) {
        return this.getBodyValue(key).asStringValue();
    }

    @Override
    public IntegerValue getBodyIntegerValue(int key) {
        return this.getBodyValue(key).asIntegerValue();
    }

    @Override
    public Value getHeaderValue(int key) {
        return this.headerMap.get(key);
    }

    @Override
    public IntegerValue getHeaderIntegerValue(int key) {
        return this.getHeaderValue(key).asIntegerValue();
    }

    @Override
    public boolean hasSyncId() {
        return this.syncId != -1L;
    }

    @Override
    public int getRequestType() {
        return this.requestType;
    }
}

