/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.balancer;

import io.tarantool.balancer.TarantoolBalancer;
import io.tarantool.balancer.exceptions.NoAvailableClientsException;
import io.tarantool.core.IProtoClient;
import io.tarantool.pool.IProtoClientPool;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarantoolDistributingRoundRobinBalancer
implements TarantoolBalancer {
    private static final Logger log = LoggerFactory.getLogger(TarantoolDistributingRoundRobinBalancer.class);
    private final IProtoClientPool pool;
    private final int[] tagsIndices;
    private final int[] groupSizes;
    private final List<String> tags;
    private int tagIndex;
    private int tagsCount;

    public TarantoolDistributingRoundRobinBalancer(IProtoClientPool pool) {
        this.pool = pool;
        this.tagIndex = 0;
        this.tags = pool.getTags();
        this.tagsCount = this.tags.size();
        this.tagsIndices = new int[this.tagsCount];
        this.groupSizes = new int[this.tagsCount];
        for (int i = 0; i < this.tagsCount; ++i) {
            this.tagsIndices[i] = 0;
            this.groupSizes[i] = pool.getGroupSize(this.tags.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<IProtoClient> getNext() {
        while (this.pool.hasAvailableClients()) {
            TarantoolDistributingRoundRobinBalancer tarantoolDistributingRoundRobinBalancer = this;
            synchronized (tarantoolDistributingRoundRobinBalancer) {
                int index = this.nextIndex();
                String tag = this.nextTag();
                CompletableFuture clientFuture = this.pool.get(tag, index);
                if (clientFuture == null) {
                    continue;
                }
                return ((CompletableFuture)clientFuture.handle((connect, exc) -> {
                    if (exc != null) {
                        log.warn("taking {}:{} failed", new Object[]{tag, index, exc});
                        return this.getNext();
                    }
                    return CompletableFuture.completedFuture(connect);
                })).thenCompose(x -> x);
            }
        }
        CompletableFuture<IProtoClient> future = new CompletableFuture<IProtoClient>();
        future.completeExceptionally(new NoAvailableClientsException());
        return future;
    }

    @Override
    public void close() throws Exception {
        this.pool.close();
    }

    @Override
    public IProtoClientPool getPool() {
        return this.pool;
    }

    private int nextIndex() {
        int n = this.tagIndex;
        int n2 = this.tagsIndices[n];
        this.tagsIndices[n] = n2 + 1;
        int idx = n2;
        if (this.tagsIndices[this.tagIndex] >= this.groupSizes[this.tagIndex]) {
            this.tagsIndices[this.tagIndex] = 0;
        }
        return idx;
    }

    private String nextTag() {
        String tag = this.tags.get(this.tagIndex++);
        if (this.tagIndex >= this.tagsCount) {
            this.tagIndex = 0;
        }
        return tag;
    }
}

