/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.balancer;

import io.tarantool.balancer.TarantoolBalancer;
import io.tarantool.balancer.TarantoolDistributingRoundRobinBalancer;
import io.tarantool.balancer.TarantoolRoundRobinBalancer;

public enum BalancerMode {
    DISTRIBUTING_ROUND_ROBIN(TarantoolDistributingRoundRobinBalancer.class),
    ROUND_ROBIN(TarantoolRoundRobinBalancer.class);

    private final Class<? extends TarantoolBalancer> balancerClass;
    public static final BalancerMode DEFAULT_BALANCER_MODE;

    private BalancerMode(Class<? extends TarantoolBalancer> balancerClass) {
        this.balancerClass = balancerClass;
    }

    public static BalancerMode valueOf(Class<? extends TarantoolBalancer> balancerClass) {
        for (BalancerMode type : BalancerMode.values()) {
            if (!balancerClass.equals(type.getBalancerClass())) continue;
            return type;
        }
        throw new IllegalArgumentException("The BalancerClass constant was not found for the specified class balancer.");
    }

    public Class<? extends TarantoolBalancer> getBalancerClass() {
        return this.balancerClass;
    }

    static {
        DEFAULT_BALANCER_MODE = BalancerMode.valueOf(TarantoolBalancer.DEFAULT_BALANCER_CLASS);
    }
}

