/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.box.options;

import io.tarantool.client.box.options.OptionsWithIndex;
import io.tarantool.core.protocol.BoxIterator;

public class SelectOptions
implements OptionsWithIndex {
    public static final int DEFAULT_LIMIT = 100;
    public static final int DEFAULT_OFFSET = 0;
    public static final long DEFAULT_TIMEOUT = 5000L;
    public static final BoxIterator DEFAULT_BOX_ITERATOR = BoxIterator.EQ;
    public static final int PRIMARY = 0;
    private final long timeout;
    private final Long streamId;
    private final int indexId;
    private final String indexName;
    private final int limit;
    private final int offset;
    private final BoxIterator iterator;
    private final boolean fetchPosition;
    private final Object after;

    private SelectOptions(long timeout, Long streamId, int indexId, String indexName, int limit, int offset, BoxIterator iterator, boolean fetchPosition, Object after) {
        this.timeout = timeout;
        this.streamId = streamId;
        this.indexId = indexId;
        this.indexName = indexName;
        this.limit = limit;
        this.offset = offset;
        this.iterator = iterator;
        this.fetchPosition = fetchPosition;
        this.after = after;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Long getStreamId() {
        return this.streamId;
    }

    @Override
    public int getIndexId() {
        return this.indexId;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public BoxIterator getIterator() {
        return this.iterator;
    }

    public boolean isPositionFetchEnabled() {
        return this.fetchPosition;
    }

    public Object getAfter() {
        return this.after;
    }

    public static class Builder {
        private long timeout = 5000L;
        private Long streamId;
        private int indexId = 0;
        private String indexName;
        private int limit = 100;
        private int offset = 0;
        private BoxIterator iterator = DEFAULT_BOX_ITERATOR;
        private boolean fetchPosition = false;
        private Object after = null;

        public Builder withTimeout(long timeout) {
            if (timeout <= 0L) {
                throw new IllegalArgumentException("timeout should be greater than 0");
            }
            this.timeout = timeout;
            return this;
        }

        public Builder withStreamId(long streamId) {
            if (streamId < 0L) {
                throw new IllegalArgumentException("streamId should be greater or equal 0");
            }
            this.streamId = streamId;
            return this;
        }

        public Builder withIndex(int indexId) {
            if (indexId < 0) {
                throw new IllegalArgumentException("index should be greater or equal 0");
            }
            this.indexId = indexId;
            return this;
        }

        public Builder withIndex(String indexName) {
            if (indexName == null) {
                throw new IllegalArgumentException("index can't be null");
            }
            this.indexName = indexName;
            return this;
        }

        public Builder withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder withOffset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder withIterator(BoxIterator iterator) {
            if (iterator == null) {
                throw new IllegalArgumentException("iterator can't be null");
            }
            this.iterator = iterator;
            return this;
        }

        public Builder fetchPosition() {
            this.fetchPosition = true;
            return this;
        }

        public Builder after(Object after) {
            this.after = after;
            return this;
        }

        public SelectOptions build() {
            return new SelectOptions(this.timeout, this.streamId, this.indexId, this.indexName, this.limit, this.offset, this.iterator, this.fetchPosition, this.after);
        }
    }
}

