/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.mapping.crud;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.tarantool.mapping.Field;
import io.tarantool.mapping.crud.CrudData;
import io.tarantool.mapping.crud.CrudError;
import io.tarantool.mapping.crud.CrudException;
import java.util.List;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
public class CrudResponse<T> {
    private final CrudData<T> response;
    private final CrudError error;

    @JsonCreator
    public CrudResponse(@JsonProperty(value="response") CrudData<T> response, @JsonProperty(value="error") CrudError error) {
        this.response = response;
        this.error = error;
    }

    public T getRows() throws CrudException {
        if (this.error != null) {
            throw new CrudException(this.error);
        }
        if (this.response == null) {
            return null;
        }
        return this.response.getRows();
    }

    public List<Field> getMetadata() throws CrudException {
        if (this.error != null) {
            throw new CrudException(this.error);
        }
        return this.response.getMetadata();
    }

    public String toString() {
        return "CrudResponse{response=" + this.response + ", error=" + this.error + '}';
    }
}

